/*
 * FileChooserFactory.java
 *
 * Created on 11 maj 2004, 17:10
 */

package pl.psnc.graph.io;

import java.util.HashMap;
import java.util.Map;

import javax.swing.JFileChooser;

/**
 * {@link FileChooserFactory} class - the abstract factory for creating the file
 * chooser dialogs.
 * 
 * @author Dominik Stoklosa
 * @email osa@man.poznan.pl
 */
public class FileChooserFactory {


	/** Stores a set of file choosers */
	private static Map<ChooserType, JFileChooser> chooserList = new HashMap<ChooserType, JFileChooser>();

	/**
	 * Gets the file chooser by the given type.s
	 * 
	 * @param type type of the current file chooser. Instance of {@link ChooserType}.
	 * @param fileFilterList list of file filters to be used for the current
	 *        file chooser.
	 * @return instance of {@link JFileChooser}.
	 */
	public static JFileChooser getFileChooser(ChooserType type, FileFilterType... fileFilterList) {
		JFileChooser chooser = chooserList.get(type);
		if (chooser == null) {
			chooser = new GraphFileChooser(fileFilterList);
			chooserList.put(type, chooser);
		}
		return chooser;
	}

}
