/*
 * Created by JFormDesigner on Fri Mar 07 10:50:16 CET 2008
 */

package pl.psnc.graph.gui;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.ResourceBundle;

import javax.swing.ImageIcon;
import javax.swing.JPanel;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.BasicMarqueeHandler;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphUndoManager;

import pl.psnc.graph.exception.GraphException;
import pl.psnc.graph.model.CustomGraph;
import pl.psnc.graph.model.CustomGraphModel;
import pl.psnc.graph.model.marquee.CustomMarqueeHandler;
import pl.psnc.graph.model.value.GraphCellObject;
import pl.psnc.graph.util.GraphHelper;
import pl.psnc.graph.util.GraphKeys;
import pl.psnc.graph.view.CustomCellViewFactory;
import pl.psnc.vlab.util.image.ImageFactory;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

/**
 * {@link JGraphPane} class - JGraph component pane
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public class JGraphPane extends JPanel {

	/** Instance of logger */
	@SuppressWarnings("unused")
	private Log log = LogFactory.getLog(JGraphPane.class);

	/** Default serial uid */
	private static final long serialVersionUID = 1L;

	/** Holds instance of JGraph */
	private transient CustomGraph graph;

	/** Holds instance of JGraph model */
	private transient CustomGraphModel graphModel;

	/** Holds the undo manager for the graph. */
	private transient GraphUndoManager undoManager;

	/**
	 * Creates a new instance of {@link JGraphPane}
	 */
	public JGraphPane() {
		initComponents();
		this.graphModel = new CustomGraphModel();
		GraphLayoutCache view = new GraphLayoutCache(graphModel, new CustomCellViewFactory());
		this.graph = new CustomGraph(graphModel, view);
		this.undoManager = new GraphUndoManager();
		graph.getModel().addUndoableEditListener(undoManager);
		graph.setMarqueeHandler(new CustomMarqueeHandler(graph));
		CellConstraints cc = new CellConstraints();
		add(graph, cc.xy(1, 1));
	}

	/**
	 * Creates a new instance of {@link JGraphPane}
	 * 
	 * @param marqueeHandler instance of {@link BasicMarqueeHandler}
	 * @throws GraphException thrown when creation fails
	 */
	public JGraphPane(BasicMarqueeHandler marqueeHandler) {
		this();
		graph.setMarqueeHandler(marqueeHandler);
	}

	/**
	 * Initialise form components
	 */
	@SuppressWarnings("unused")
	private void initComponents() {
		// JFormDesigner - Component initialization - DO NOT MODIFY
		// //GEN-BEGIN:initComponents
		// Generated using JFormDesigner non-commercial license
		ResourceBundle bundle = ResourceBundle.getBundle("bundle.gui");
		CellConstraints cc = new CellConstraints();

		// ======== this ========
		setName("this");

		PanelBuilder builder = new PanelBuilder(
				new FormLayout("default:grow", "fill:default:grow"), this);

		// //GEN-END:initComponents
	}

	// JFormDesigner - Variables declaration - DO NOT MODIFY
	// //GEN-BEGIN:variables
	// Generated using JFormDesigner non-commercial license
	// JFormDesigner - End of variables declaration //GEN-END:variables

	// --------------------------------------------------------------------------------------
	// ---- Setters / getters

	/**
	 * Get value of the property: graph
	 * 
	 * @return the graph
	 */
	public CustomGraph getGraph() {
		return graph;
	}

	// --------------------------------------------------------------------------------------
	// ---- Public helper methods

	/**
	 * Insert a new Vertex at the given point
	 * 
	 * @param point insertion location, an instance of {@link Point}
	 * @param vertex node to be inserted, an instance of
	 *            {@link DefaultGraphCell}
	 * @throws GraphException thrown when insertion fails
	 */
	public void insert(Point2D point, DefaultGraphCell vertex) throws GraphException {
		AttributeMap map = vertex.getAttributes();

		// Default Size for the new Vertex
		GraphCellObject cellObject = GraphHelper.getUserObject(vertex);
		ImageIcon vartexIcon = ImageFactory.getImageBean(cellObject.getType().getImage())
				.getImage();
		Dimension size = new Dimension(vartexIcon.getIconWidth(), vartexIcon.getIconHeight());
		// GraphConstants.setIcon(map, vartexIcon);
		// Add a Bounds Attribute to the Map
		point = graph.snap(map.createPoint(point));
		GraphConstants.setBounds(map, new Rectangle2D.Double(point.getX(), point.getY(),
				size.width, size.height + GraphKeys.VERTEX_LABEL_MARGIN));
		HashMap<DefaultGraphCell, AttributeMap> attributes = new HashMap<DefaultGraphCell, AttributeMap>();
		attributes.put(vertex, map);
		graph.getGraphLayoutCache().insert(vertex);
	}
}
