/*
 * GraphEditorFactory.java
 *
 * Created on 13 maj 2004, 12:26
 */

package pl.psnc.graph.factory;

import org.jgraph.graph.BasicMarqueeHandler;

import pl.psnc.graph.gui.JGraphPane;

/**
 * {@link GraphEditorFactory} class - factory is responsible for creating
 * destroying and storing the JGraph Editor.
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public class GraphEditorFactory {

	/** The Scenario graph editor instance */
	private static JGraphPane instance = null;

	/**
	 * Gets new instance of graph editor, instance of {@link JGraphPane}
	 * 
	 * @return new instance of graph editor
	 */
	public static JGraphPane getGraphEditorInstance() {
		return instance;
	}

	/**
	 * Create a new instance of {@link JGraphPane}, which contains JGraph
	 * component.Scenario Graph Editor
	 * 
	 * @return new instance of {@link JGraphPane}
	 */
	public static JGraphPane createNewInstance(BasicMarqueeHandler marqueeHandler) {
		instance = new JGraphPane(marqueeHandler);
		return instance;
	}

}
