package pl.psnc.graph.factory;

import java.awt.Color;

import javax.swing.ImageIcon;

import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.DefaultEdge;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.DefaultPort;
import org.jgraph.graph.GraphConstants;

import pl.psnc.graph.model.type.AbstractResourceType;
import pl.psnc.graph.model.type.AbstractResourceValue;
import pl.psnc.graph.model.value.GraphCellObject;
import pl.psnc.graph.vertex.CustomPort;
import pl.psnc.graph.vertex.ImageCell;
import pl.psnc.vlab.util.image.ImageFactory;

/**
 * {@link GraphCellFactory} class - abstract factory class for graph nodes
 * creation.
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public class GraphCellFactory {

	/**
	 * Creates new graph cell
	 * 
	 * @param type specifies type of the cell which will be created.
	 * @param resourceValue instance of {@link AbstractResourceValue}
	 * @return new instance of {@link DefaultGraphCell}
	 */
	public static DefaultGraphCell createCell(AbstractResourceType type,
			AbstractResourceValue resourceValue) {

		// resourceValue.setId(WfmResourceFactory.nextSequenceNumber());
		GraphCellObject cellObject = new GraphCellObject(type, resourceValue);
		ImageCell imageCell = new ImageCell(cellObject);
		DefaultPort port = createPort();
		// add port
		imageCell.add(port);
		port.setParent(imageCell);

		AttributeMap map = imageCell.getAttributes();
		ImageIcon image = ImageFactory.getImageBean(type.getImage()).getImage();
		GraphConstants.setIcon(map, image);
		GraphConstants.setInset(map, 4);
		GraphConstants.setAutoSize(map, true);
		GraphConstants.setLineColor(map, Color.red);
		GraphConstants.setLineWidth(map, 4);
		GraphConstants.setConnectable(map, true);
		GraphConstants.setDisconnectable(map, true);
		GraphConstants.setSizeable(map, false);
		GraphConstants.setEditable(map, false);

		return imageCell;
	}

	/**
	 * Creates new graph port
	 * 
	 * @return new instance of {@link DefaultPort}
	 */
	public static DefaultPort createPort() {
		return new CustomPort();
	}

	/**
	 * Creates new graph edge
	 * 
	 * @return new instance of {@link DefaultEdge}
	 */
	public static DefaultEdge createEdge() {
		DefaultEdge edge = new DefaultEdge();
		AttributeMap map = edge.getAttributes();
		GraphConstants.setLineEnd(map, GraphConstants.ARROW_SIMPLE);
		return edge;
	}

}
