package pl.psnc.graph.exception;

import pl.psnc.vlab.exception.AbstractException;

/**
 * {@link GraphException} class - represents the exceptions which are thrown by
 * the JGraph component.
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public class GraphException extends AbstractException {

	/** Default serial uid */
	private static final long serialVersionUID = 1L;

	/** Stores a default name of resource bundle container */
	private final static String BUNDLE = "bundle/graphErrorMessages";

	/**
	 * Creates a new instance of {@link GraphException} with error code
	 * specified.
	 * 
	 * @param errorCode exception error code
	 */
	public GraphException(Integer errorCode) {
		super(errorCode);
	}

	/**
	 * Creates a new instance of {@link GraphException} with error code and
	 * source exception specified.
	 * 
	 * @param errorCode exception error code
	 * @param error instance of source exception
	 */
	public GraphException(Integer errorCode, Exception error) {
		super(errorCode, error);
	}

	/**
	 * Creates a new instance of {@link GraphException} with error code and
	 * message key / message specified.
	 * 
	 * @param errorCode exception error code
	 * @param messageKey message key to be taken from specified BUNDLE
	 */
	public GraphException(Integer errorCode, String messageKey) {
		super(errorCode, messageKey);
	}

	/**
	 * Creates a new instance of {@link GraphException} with error code and
	 * message key / message specified.
	 * 
	 * @param messageKey message key to be taken from specified BUNDLE
	 * @param error instance of source exception
	 */
	public GraphException(String messageKey, Exception error) {
		super(0, messageKey, error);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see pl.psnc.vlab.exception.AbstractException#getBundle()
	 */
	@Override
	public String getBundle() {
		return BUNDLE;
	}

}
