package pl.psnc.graph.action.factory;

import pl.psnc.graph.action.CopyAction;
import pl.psnc.graph.action.DeleteAction;
import pl.psnc.graph.action.PasteAction;
import pl.psnc.graph.action.RedoAction;
import pl.psnc.graph.action.UndoAction;
import pl.psnc.graph.action.ZoomActualAction;
import pl.psnc.graph.action.ZoomInAction;
import pl.psnc.graph.action.ZoomOutAction;
import pl.psnc.vlab.util.gui.action.AbstractActionDefault;
import pl.psnc.vlab.util.gui.action.factory.ActionType;

/**
 * {@link GraphActionType} class - defines jgraph related actions.
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */

public enum GraphActionType implements ActionType {
	COPY(CopyAction.class),
	PASTE(PasteAction.class),
	DELETE(DeleteAction.class),
	ZOOM_ACTUAL_SIZE(ZoomActualAction.class),
	ZOOM_IN(ZoomInAction.class),
	ZOOM_OUT(ZoomOutAction.class),

	UNDO(UndoAction.class),
	REDO(RedoAction.class);

	/** Stores action type */
	private Class<? extends AbstractActionDefault> type;

	/**
	 * Creates new GraphActionType
	 * 
	 */
	private GraphActionType(Class<? extends AbstractActionDefault> type) {
		this.type = type;
	}

	// ----------------------------------------------------------------------------------------
	// ---- Getters

	/*
	 * (non-Javadoc)
	 * 
	 * @see pl.psnc.vlab.util.gui.action.factory.ActionType#getType()
	 */
	public Class<? extends AbstractActionDefault> getType() {
		return type;
	}

}
