/**
 * AbstractGraphAction.java
 * Created on Apr 30, 2008
 */
package pl.psnc.graph.action.factory;

import pl.psnc.graph.exception.GraphException;
import pl.psnc.graph.factory.GraphEditorFactory;
import pl.psnc.graph.model.CustomGraph;
import pl.psnc.vlab.util.gui.action.LocalizedAbstractAction;

/**
 * {@link AbstractGraphAction} class - abstract, top level class for all graph
 * actions
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public abstract class AbstractGraphAction extends LocalizedAbstractAction {

	/** Stores name of the resource bundle file */
	private static final String BUNDLE = "bundle/jgraph";

	/**
	 * Define an Action Object with a specified action name, icon and short
	 * description.
	 * 
	 * @param nameKey name of the action. Key from the resource bundle
	 * @param iconPath the icon for the current action
	 * @param description action short description
	 */
	public AbstractGraphAction(String nameKey, String iconPath, String description) {
		super(nameKey, iconPath, description);
	}

	// ----------------------------------------------------------------------------------------
	// ---- Public helper methods

	/**
	 * Return an instance of the current Scenario Graph for the current Graph
	 * Editor.
	 * 
	 * @return instance of the current Scenario Graph for the current Graph
	 */
	public CustomGraph getCurrentGraph() throws GraphException {
		return GraphEditorFactory.getGraphEditorInstance().getGraph();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see pl.psnc.vlab.util.gui.action.LocalizedAbstractAction#getBundle()
	 */
	@Override
	public String getBundle() {
		return BUNDLE;
	}

}
