package pl.psnc.graph.action;

import java.awt.event.ActionEvent;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import pl.psnc.graph.action.factory.AbstractGraphAction;
import pl.psnc.graph.action.factory.GraphActionType;
import pl.psnc.graph.model.CustomGraph;
import pl.psnc.graph.util.image.ImageKeys;
import pl.psnc.vlab.util.gui.action.factory.ActionFactory;

/**
 * {@link ZoomOutAction} class - represents the zoom out action
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public class ZoomOutAction extends AbstractGraphAction {

	/** Default serial uid */
	private static final long serialVersionUID = 1L;

	/** Instance of logger */
	private Log log = LogFactory.getLog(ZoomOutAction.class);

	/** Stores instance of field: MIN */
	private static double MIN = 1.0 / 8.0;

	/** Stores instance of field: STEP */
	private static double STEP = 1.5;

	/**
	 * Creates a new instance of zoom out Action. The action is created with the
	 * default name, icons, mnemonic and accelerator key - these are taken from
	 * the resource bundle
	 */
	public ZoomOutAction() {
		super("action.zoom.out.name", ImageKeys.ZOOM_OUT, "action.zoom.out.tip");
		setMnemonic("action.zoom.out.mnemonic");
		setAcceleratorKey("action.zoom.out.shortcut");
		setDisabledActionIcon(ImageKeys.ZOOM_OUT_DISABLED);
	}

	/**
	 * @see java.awt.event.ActionListener#actionPerformed(ActionEvent)
	 */
	public void actionPerformed(ActionEvent e) {
		try {
			CustomGraph graph = getCurrentGraph();
			// graph.setResizeAction(null);
			double scale = graph.getScale();
			scale /= STEP;
			if (scale < MIN) {
				this.setEnabled(false);
			} else {
				graph.setScale(scale);
				scrollCellToVisible(graph);
				ActionFactory.getAction(GraphActionType.ZOOM_IN).setEnabled(true);
			}
		} catch (Exception err) {
			log.error("Error" + err.getMessage());
		}
	}

	/**
	 * Scrolls the cell to the given scale
	 * 
	 * @param graph
	 */
	private void scrollCellToVisible(CustomGraph graph) {
		Object selectionCells[] = graph.getSelectionCells();
		if (selectionCells != null) {
			graph.scrollCellToVisible(selectionCells);
		}
	}
}
