package pl.psnc.graph.action;

import java.awt.event.ActionEvent;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import pl.psnc.graph.action.factory.AbstractGraphAction;
import pl.psnc.graph.action.factory.GraphActionType;
import pl.psnc.graph.model.CustomGraph;
import pl.psnc.graph.util.image.ImageKeys;
import pl.psnc.vlab.util.gui.action.factory.ActionFactory;

/**
 * {@link ZoomInAction} class - represents the zoom in action
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public class ZoomInAction extends AbstractGraphAction {

	/** Default serial uid */
	private static final long serialVersionUID = 1L;

	/** Instance of logger */
	private Log log = LogFactory.getLog(ZoomInAction.class);

	/** Stores instance of field: MAX */
	private static double MAX = 5.0;

	/** Stores instance of field: STEP */
	private static double STEP = 1.5;

	/**
	 * Creates a new instance of zoom in Action. The action is created with the
	 * default name, icons, mnemonic and accelerator key - these are taken from
	 * the resource bundle
	 */
	public ZoomInAction() {
		super("action.zoom.in.name", ImageKeys.ZOOM_IN, "action.zoom.in.tip");
		setMnemonic("action.zoom.in.mnemonic");
		setAcceleratorKey("action.zoom.in.shortcut");
		setDisabledActionIcon(ImageKeys.ZOOM_IN_DISABLED);
	}

	/**
	 * @see java.awt.event.ActionListener#actionPerformed(ActionEvent)
	 */
	public void actionPerformed(ActionEvent e) {
		try {
			CustomGraph graph = getCurrentGraph();
			// graph.setResizeAction(null);
			double scale = graph.getScale();
			scale *= STEP;
			log.debug("Current scale-" + scale);
			if (scale >= MAX) {
				this.setEnabled(false);
			} else {
				graph.setScale(scale);
				scrollCellToVisible(graph);
				ActionFactory.getAction(GraphActionType.ZOOM_OUT).setEnabled(true);
			}
		} catch (Exception err) {
			log.error("Error" + err.getMessage());
		}
	}

	/**
	 * Scrolls the cell to the given scale
	 * 
	 * @param graph
	 */
	private void scrollCellToVisible(CustomGraph graph) {
		Object selectionCells[] = graph.getSelectionCells();
		if (selectionCells != null) {
			graph.scrollCellToVisible(selectionCells);
		}
	}
}
