package pl.psnc.graph.action;

import java.awt.event.ActionEvent;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgraph.JGraph;
import org.jgraph.util.JGraphUtilities;

import pl.psnc.graph.action.factory.AbstractGraphAction;
import pl.psnc.graph.model.CustomGraph;
import pl.psnc.graph.util.image.ImageKeys;
import pl.psnc.vlab.exception.ResourceNotFoundException;
import pl.psnc.vlab.util.gui.message.JMessage;

/**
 * {@link DeleteAction} class - delete action
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public class DeleteAction extends AbstractGraphAction {

	/** Default serial uid */
	private static final long serialVersionUID = 1L;

	/** Instance of logger */
	private Log log = LogFactory.getLog(this.getClass().getName());

	/**
	 * Creates a new instance of Delete Action. The Delete action is used to
	 * clone the existing nodes. The action is created with the default name,
	 * icons, mnemonic and accelerator key - these are taken from the resource
	 * bundle
	 */
	public DeleteAction() throws ResourceNotFoundException {
		super("action.delete.name", ImageKeys.DELETE, "action.delete.tip");
		setMnemonic("action.delete.mnemonic");
		setAcceleratorKey("action.delete.shortcut");
		setDisabledActionIcon(ImageKeys.DELETE_DISABLED);
	}

	/**
	 * @see java.awt.event.ActionListener#actionPerformed(ActionEvent)
	 */
	public void actionPerformed(ActionEvent e) {
		CustomGraph graph = null;
		try {
			// Get Selected Cells
			graph = getCurrentGraph();
			Object[] cells = graph.getSelectionCells();
			if (cells != null) {
				// Remove Cells (incl. Descendants) from the Model
				graph.getModel().remove(graph.getDescendants(cells));
				// remove arrows
				Object edges[] = JGraphUtilities.getEdges(graph);
				removeEdges(graph, edges);
			}
		} catch (Exception err) {
			log.error("Error" + err.getMessage());
			JMessage.showErrorMessage(graph, err.getLocalizedMessage());
		}
	}

	// TODO move it to the common utitliy class
	/**
	 * Removes the unused edges
	 * 
	 * @param edges
	 */
	private void removeEdges(JGraph graph, Object edges[]) {
		int size = edges != null ? edges.length : 0;
		for (int i = 0; i < size; i++) {
			if (JGraphUtilities.getSourceVertex(graph, edges[i]) == null
					|| JGraphUtilities.getTargetVertex(graph, edges[i]) == null) {
				JGraphUtilities.removeCells(graph, new Object[] { edges[i] });
			}
		}
	}

}
