package pl.psnc.graph.action;

import java.awt.event.ActionEvent;

import javax.swing.TransferHandler;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import pl.psnc.graph.action.factory.AbstractGraphAction;
import pl.psnc.graph.action.factory.GraphActionType;
import pl.psnc.graph.model.CustomGraph;
import pl.psnc.graph.util.image.ImageKeys;
import pl.psnc.vlab.exception.ResourceNotFoundException;
import pl.psnc.vlab.util.gui.action.factory.ActionFactory;
import pl.psnc.vlab.util.gui.message.JMessage;

/**
 * {@link CopyAction} class - handles the copy event.
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public class CopyAction extends AbstractGraphAction {

	/** Default serial uid */
	private static final long serialVersionUID = 1L;

	/** Instance of logger */
	private Log log = LogFactory.getLog(this.getClass().getName());

	/**
	 * Creates a new instance of Copy Action. The copy action is used to clone
	 * the existing nodes. The action is created with the default name, icons,
	 * mnemonic and accelerator key - these are taken from the resource bundle
	 * 
	 * @throws ResourceNotFoundException
	 */
	public CopyAction() throws ResourceNotFoundException {
		super("action.copy.name", ImageKeys.COPY, "action.copy.tip");
		setMnemonic("action.copy.mnemonic");
		setAcceleratorKey("action.copy.shortcut");
		setDisabledActionIcon(ImageKeys.COPY_DISABLED);
	}

	/**
	 * @see java.awt.event.ActionListener#actionPerformed(ActionEvent)
	 */
	public void actionPerformed(ActionEvent e) {
		CustomGraph currentGraph = null;
		try {
			currentGraph = getCurrentGraph();
			TransferHandler.getCopyAction().actionPerformed(
					new ActionEvent(currentGraph, e.getID(), e.getActionCommand()));
			ActionFactory.getAction(GraphActionType.PASTE).setEnabled(true);
		} catch (Exception err) {
			log.error("Error" + err.getMessage());
			JMessage.showErrorMessage(currentGraph, err.getLocalizedMessage());
		}

	}
}
