/*
 * ComponentFactory.java
 *
 * Created on 26 maj 2004, 15:58
 */

package pl.psnc.expres.xml;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import pl.psnc.expres.model.experiment.ExperimentInfo;
import pl.psnc.expres.model.experiment.VlbiExperiment;

/**
 * The Dynamic Scenario Builder class is used to build the model of the scenario
 * created by the user
 * 
 * @author Dominik Stoklosa
 * @email osa@man.poznan.pl
 */
public class ScenarioBuilder {

	/** Instance of logger */
	private static Log log = LogFactory.getLog(ScenarioBuilder.class.getName());

	/** Holds the vlbi experiment */
	private static VlbiExperiment vlbiExperiment;

	/**
	 * Returns instance of VLBI Experiment description value object
	 * 
	 * @return VlbiExperiment value object
	 */
	public static VlbiExperiment getExperimentInstance() {
		if (vlbiExperiment == null) {
			vlbiExperiment = new VlbiExperiment();
		}
		return vlbiExperiment;
	}

	/**
	 * Get Vlbi Experiment Info value object
	 * 
	 * @return ExperimentInfo value object
	 */
	public static ExperimentInfo getExperimentDetails() {
		return getExperimentInstance().getInfo();
	}

	/**
	 * Set Vlbi Experiment Info
	 * 
	 */
	public static void setExperimentDetails(ExperimentInfo experimentInfo) {
		getExperimentInstance().setInfo(experimentInfo);
	}

	/**
	 * Create a new instance of the Rds Document. If document given as an
	 * argument is != null then it becomes active Rds Document.
	 * 
	 * @param vlbiExperiment
	 */
	/*
	 * removed TBD public static void createInstace(RdsDocument rdsDoc){
	 * if(rdsDoc == null){ log.debug("<createInstace>"); vlbiExperiment =
	 * RdsDocument.Factory.newInstance();
	 * vlbiExperiment.addNewRds().addNewResources();
	 * vlbiExperiment.getRds().addNewScenario(); //set dates
	 * ScenarioDocument.Scenario scen = vlbiExperiment.getRds().getScenario();
	 * SystemConfigurationValue sysConfVO =
	 * SystemConfigurationFactory.getInstance(); DateTools dateTools = new
	 * DateTools(sysConfVO.getCurrentLocale(), Keys.DATE_FORMAT,
	 * Keys.TIME_FORMAT); Date curDate = new Date();
	 * //JMainFrame.getInstance().getStatusBar().getCurrentDate(); String date =
	 * dateTools.getDateAsString(curDate); String time =
	 * dateTools.getTimeAsString(curDate); scen.setCreationDate(date+" "+time);
	 * scen.setModificationDate(date+" "+time);
	 * vlbiExperiment.getRds().setScenario(scen); } else { vlbiExperiment =
	 * rdsDoc; } log.debug("</createInstace>"); }
	 */

}
