/**
 * ResourceFactory.java
 * Created on Nov 15, 2007, 3:40:34 PM
 */
package pl.psnc.expres.wfm.model.factory;

import java.io.InputStream;

import pl.psnc.expres.model.factory.ResourceFactory;
import pl.psnc.expres.model.resource.ResourceValue;
import pl.psnc.expres.wfm.management.WfmConfiguration;
import pl.psnc.vlab.conf.ConfigFactory;
import pl.psnc.vlab.exception.ResourceNotFoundException;
import pl.psnc.vlab.exception.VlabException;

/**
 * {@link WfmResourceFactory} class - factory class for retrieving resources and
 * their properties
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 */
public class WfmResourceFactory {

	/** Identifier generator */
	private static int sequencer = 1;

	/**
	 * Get the resource by the given id
	 * 
	 * @param id resource id
	 * @return resource value object
	 */
	public static ResourceValue getResource(int id) throws ResourceNotFoundException {
		try {
			WfmConfiguration configVo = (WfmConfiguration) ConfigFactory.getConfigFactory();
			ResourceValue result = ResourceFactory.getResource(id, configVo
					.getResourcePropertiesLocation());
			return (ResourceValue) result.clone();
		} catch (VlabException e) {
			throw new ResourceNotFoundException(e.getMessage(), e);
		} catch (CloneNotSupportedException e) {
			// TODO add i18n
			throw new ResourceNotFoundException("Error while clonnig ResourceValue object", e);
		}
	}

	/**
	 * Get the resource by resource abbreviation
	 * 
	 * @param abbr resource abbreviation
	 * @return instance of {@link ResourceValue}
	 * @throws ResourceNotFoundException when resource with the given
	 *             abbreviation does not exist
	 */
	public static ResourceValue getResource(String abbr) throws ResourceNotFoundException {
		try {
			WfmConfiguration configVo = (WfmConfiguration) ConfigFactory.getConfigFactory();
			String location = configVo.getResourcePropertiesLocation();
			InputStream resourceAsStream = WfmResourceFactory.class.getResourceAsStream(location);
			ResourceValue result = ResourceFactory.getResource(abbr, resourceAsStream);
			return (ResourceValue) result.clone();
		} catch (VlabException e) {
			throw new ResourceNotFoundException(e.getMessage(), e);
		} catch (CloneNotSupportedException e) {
			// TODO add i18n
			throw new ResourceNotFoundException("Error while clonnig ResourceValue object", e);
		}
	}

	/**
	 * Get next resource identifier
	 * 
	 * @return next integer value. Sequencer starts with 1.
	 */
	public static int nextSequenceNumber() {
		return ++sequencer;
	}

}
