/*
 * WfmConfigurationImpl.java
 *
 * Created on February 21, 2006, 3:40 PM
 *
 */

package pl.psnc.expres.wfm.management;

import pl.psnc.vlab.conf.ConfigurationImpl;
import pl.psnc.vlab.exception.VlabException;

/**
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 */
public class WfmConfigurationImpl extends ConfigurationImpl implements WfmConfiguration {

	/**
	 * Creates a new instance of WfmConfigurationImpl
	 * 
	 * @param appConfig a path to the file, which contains the app configuration
	 *        (as a properties)
	 */
	public WfmConfigurationImpl(String appConfig) throws VlabException {
		super(appConfig);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see pl.psnc.expres.wfm.management.WfmConfiguration#getDeviceLocation()
	 */
	public String getDeviceLocation() {
		return getProperty(KEY_DEVICE_LOCATION);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see pl.psnc.expres.wfm.management.WfmConfiguration#getResourceLinksLocation()
	 */
	public String getResourceLinksLocation() {
		return getProperty(KEY_RESOURCE_LINKS);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see pl.psnc.expres.wfm.management.WfmConfiguration#getResourcePropertiesLocation()
	 */
	public String getResourcePropertiesLocation() {
		return getProperty(KEY_RESOURCE_PROPERTIES);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see pl.psnc.expres.wfm.management.WfmConfiguration#getResourceTypesLocation()
	 */
	public String getResourceTypesLocation() {
		return getProperty(KEY_RESOURCE_TYPES);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see pl.psnc.expres.wfm.management.WfmConfiguration#getVlbiBrokerServiceLocation()
	 */
	public String getVlbiBrokerServiceLocation() {
		return getProperty(KEY_VLBI_BROKER_LOCATION);
	}

}
