/*
 * SystemConfigurationValue.java
 *
 * Created on 20 marzec 2003, 23:47
 */

package pl.psnc.expres.wfm.management;

import java.util.Locale;
import java.util.TimeZone;

/**
 * 
 * @author Dominik Stoklosa
 */
public class SystemConfigurationValue implements java.io.Serializable {

	/** Serial Version ID */
	private static final long serialVersionUID = 987654321L;

	/** Holds value of property currentLocale. */
	private Locale currentLocale;

	/** Holds value of property userId. */
	private transient int userId;

	/** Holds value of property userName. */
	private transient String userName;

	/** Holds value of property timeZone. */
	private transient TimeZone timeZone;

	/** Creates a new instance of SystemConfigurationValue */
	public SystemConfigurationValue() {
		this.currentLocale = Locale.getDefault();
	}

	/**
	 * Getter for property currentLocale.
	 * 
	 * @return Value of property currentLocale.
	 * 
	 */
	public Locale getCurrentLocale() {
		return this.currentLocale;
	}

	/**
	 * Setter for property currentLocale.
	 * 
	 * @param currentLocale New value of property currentLocale.
	 * 
	 */
	public void setCurrentLocale(Locale currentLocale) {
		this.currentLocale = currentLocale;
		Locale.setDefault(this.currentLocale);
	}

	/**
	 * Getter for property userId.
	 * 
	 * @return Value of property userId.
	 * 
	 */
	public int getUserId() {
		return this.userId;
	}

	/**
	 * Setter for property userId.
	 * 
	 * @param userId New value of property userId.
	 * 
	 */
	public void setUserId(int userId) {
		this.userId = userId;
	}

	/**
	 * Getter for property userName.
	 * 
	 * @return Value of property userName.
	 * 
	 */
	public String getUserName() {
		return this.userName;
	}

	/**
	 * Setter for property userName.
	 * 
	 * @param userName New value of property userName.
	 * 
	 */
	public void setUserName(String userName) {
		this.userName = userName;
	}

	/**
	 * Getter for property timeZone.
	 * 
	 * @return Value of property timeZone.
	 */
	public TimeZone getTimeZone() {

		return this.timeZone;
	}

	/**
	 * Setter for property timeZone.
	 * 
	 * @param timeZone New value of property timeZone.
	 */
	public void setTimeZone(TimeZone timeZone) {

		this.timeZone = timeZone;
	}

}
