/*
 * ReadingsConfigurationFactory.java
 *
 * Created on 8 luty 2003, 18:58
 */

package pl.psnc.expres.wfm.management;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import pl.psnc.expres.wfm.util.Keys;
import pl.psnc.vlab.conf.ConfigFactory;
import pl.psnc.vlab.conf.IConfiguration;


/**
 *
 * @author  Dominik Stoklosa
 */
public class SystemConfigurationFactory  {
    
    /** Logger instacne */
    private static Log log = LogFactory.getLog("pl.psnc.expres.wfm.management.SystemConfigurationFactory");
    
    /** Instacne of system configuration value object*/
    private static SystemConfigurationValue instance = null;
    
    /** Creates a new instance of ReadingsConfigurationFactory */
    public SystemConfigurationFactory() {
    }
    
    //------------------------------------------------------
    
    /** Gets instance of SystemConfigurationValue
     * @throws IOException
     * @return
     */
    public static SystemConfigurationValue getInstance(){
        if(instance ==  null){            
            SystemConfigurationValue systemConfVO = deserializeFromFile();
            if(systemConfVO==null) {
                instance = new SystemConfigurationValue();
                serializeToFile();
            } else {
                instance = systemConfVO;
            }        
        }
        return instance;
    }
    
    //-------------------------------------------------
    public static void setInstance(SystemConfigurationValue systemConfVO){
        instance = systemConfVO;
    }
    
    
    //-------------------------------------------------
    /** Serialize the SystemConfigurationValue object to file.
     * @throws IOException
     */
    public static void serializeToFile() {
        try{            
            //gets the file path
            IConfiguration conf = ConfigFactory.getConfigFactory();
            String path = conf.getSystemConfDir()+Keys.FILE_SEPARATOR+conf.getAppName() + Keys.SYSTEM_CONF_EXT;
            log.debug("Saving configuration to :"+path);
            
            ObjectOutputStream out = new ObjectOutputStream( new FileOutputStream(path));
            if(instance == null) {
                instance = new SystemConfigurationValue();
            }
            out.writeObject(instance);
            out.close();
            
        }catch(Exception e){
            e.printStackTrace();
            log.debug("Serialization error");
        }
    }
    
    //-------------------------------------------------
    /** Deserialize the SystemConfigurationValue object from file
     * @return
     */
    public static SystemConfigurationValue deserializeFromFile()  {
        try{            
            //gets the file path
            IConfiguration conf = ConfigFactory.getConfigFactory();
            String path = conf.getSystemConfDir()+Keys.FILE_SEPARATOR+conf.getAppName() + Keys.SYSTEM_CONF_EXT;
            
            log.debug("Getting configuration from :"+path);
            //gets the file path            
            ObjectInputStream out = new ObjectInputStream( new FileInputStream(path));
            SystemConfigurationValue systemConfVO = (SystemConfigurationValue) out.readObject();
            out.close();
            return systemConfVO;
        } catch(Exception er){
            log.debug("Configuration file was not found. Creating new one.");
            //create default file
            serializeToFile();
            return instance;
        }
    }
}