/*
 * SplashDialogWorker.java
 *
 * Created on 9 sierpie� 2004, 15:13
 */

package pl.psnc.expres.wfm.management;

import javax.swing.JDialog;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import pl.psnc.expres.wfm.exception.WfmException;
import pl.psnc.vlab.util.swing.thread.LongTask;
import pl.psnc.vlab.util.swing.thread.SwingWorker;

/**
 * SplashDialogWorker thread opens an splash window
 * @author  Dominik Stoklosa
 * @email  osa@man.poznan.pl
 */
public class SplashDialogWorker implements LongTask{
    
    
    /** Logger instance */
    private Log log = LogFactory.getLog(this.getClass().getName());
    
    /** Represents an exception */
    private Exception error = null;
    
    /** Long tastk status */
    private boolean done = false;
    
    /** Instance of the Splash Dialog */
    private JDialog splashDialog = null;
    
    /** Creates a new instance of AppInitializer */
    public SplashDialogWorker(JDialog splashDialog) {
        this.splashDialog = splashDialog;
        
        final SwingWorker worker = new SwingWorker() {
            public Object construct() {
                return new SplashOpener();
            }
                        
        };
        worker.start();        
    }
    
    public boolean exceptionThrown() {
        return error!=null;    
    }
    
    public int getCurrent() {
        return 0;   
    }
    
    public Exception getException() {
        return error;    
    }
    
    public Object getResult() {
        return null;    
    }
    
    public int getTaskLength() {
        return 0;    
    }
    
    public boolean isDone() {
        return done;   
    }
    
    //tbd
    public int getProgress() {
        return 0;
    }    
    
    
    
    /**
     * The actual long running task.  This runs in a SwingWorker thread.
     */
    class SplashOpener {
        SplashOpener() {
            try{
                log.debug("<SplashOpener>");               
                splashDialog.setVisible(true);
                done = true;
                log.debug("</SplashOpener>");
            } catch(java.lang.Exception er) {
                er.printStackTrace();
                done = true;
                log.debug("</SplashOpener-Err>");                
                error = new WfmException(er.getLocalizedMessage(), er);
            }
            
        }        
    }// end of inner class
}