/*
 * Created by JFormDesigner on Fri Jul 25 13:48:36 CEST 2008
 */

package pl.psnc.expres.wfm.gui.scenario;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingConstants;
import javax.swing.border.LineBorder;

import pl.psnc.expres.model.experiment.ExperimentInfo;
import pl.psnc.expres.wfm.gui.JAbstractHeaderPane;
import pl.psnc.vlab.util.gui.frame.JGenericPane;
import pl.psnc.vlab.util.gui.helper.FormHelper;

import com.jgoodies.forms.factories.DefaultComponentFactory;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpec;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Sizes;

/**
 * {@link JScenarioPropertiesPane} class - scenario properties class
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public class JScenarioPropertiesPane extends JDialog {

	/** Stores instance of field: serialVersionUID */
	private static final long serialVersionUID = 1L;

	/** Stores instance of field: experimentInfo */
	private final ExperimentInfo experimentInfo;

	/**
	 * Creates a new instance of {@link JScenarioPropertiesPane}
	 * 
	 * @param owner owner class
	 * @param experimentInfo instance of {@link ExperimentInfo}
	 */
	public JScenarioPropertiesPane(Frame owner, ExperimentInfo experimentInfo) {
		super(owner);
		this.experimentInfo = experimentInfo;
		initComponents();
		initForm();
	}

	/**
	 * Initialises form components
	 */
	private void initComponents() {
		// JFormDesigner - Component initialization - DO NOT MODIFY
		// //GEN-BEGIN:initComponents
		// Generated using JFormDesigner non-commercial license
		ResourceBundle bundle = ResourceBundle.getBundle("bundle.gui");
		DefaultComponentFactory compFactory = DefaultComponentFactory.getInstance();
		jHeaderPane = new JAbstractHeaderPane();
		jHTitleLbl = compFactory.createTitle(bundle
				.getString("jscenario.properties.pane.jHTitleLbl.textWithMnemonic"));
		jHTitleIcon = new JLabel();
		jHTitleDescLbl = compFactory.createLabel(bundle
				.getString("jscenario.properties.pane.jHTitleDescLbl.textWithMnemonic"));
		jContentPane = new JGenericPane();
		goodiesFormsSeparator1 = compFactory.createSeparator(bundle
				.getString("jscenario.properties.pane.goodiesFormsSeparator1.text"));
		jScenName = compFactory.createTitle(bundle
				.getString("jscenario.properties.pane.jScenName.textWithMnemonic"));
		jNameTFld = new JTextField();
		jScenDesc = compFactory.createTitle(bundle
				.getString("jscenario.properties.pane.jScenDesc.textWithMnemonic"));
		scrollPane1 = new JScrollPane();
		jDescriptionTArea = new JTextArea();
		jDatesTitle = compFactory.createSeparator(bundle
				.getString("jscenario.properties.pane.jDatesTitle.text"));
		jCreationDate = compFactory.createTitle(bundle
				.getString("jscenario.properties.pane.jCreationDate.textWithMnemonic"));
		jCreationDateTFld = new JTextField();
		jScenModDate = compFactory.createTitle(bundle
				.getString("jscenario.properties.pane.jScenModDate.textWithMnemonic"));
		jModificationDateTFld = new JTextField();
		jScenModifiedBy = compFactory.createTitle(bundle
				.getString("jscenario.properties.pane.jScenModifiedBy.textWithMnemonic"));
		jModifiedByTFld = new JTextField();
		jButtonPane = new JPanel();
		jOkBtn = new JButton();
		jCancelBtn = new JButton();
		CellConstraints cc = new CellConstraints();

		// ======== this ========
		setModal(true);
		setName("this");
		Container contentPane = getContentPane();
		contentPane.setLayout(new FormLayout(ColumnSpec.decodeSpecs("default:grow"), new RowSpec[] {
				new RowSpec(RowSpec.FILL, Sizes.dluY(72), FormSpec.NO_GROW),
				FormFactory.LINE_GAP_ROWSPEC,
				new RowSpec(RowSpec.FILL, Sizes.DEFAULT, FormSpec.DEFAULT_GROW) }));

		// ======== jHeaderPane ========
		{
			jHeaderPane.setBorder(LineBorder.createBlackLineBorder());
			jHeaderPane.setPreferredSize(new Dimension(400, 100));
			jHeaderPane.setName("jHeaderPane");
			jHeaderPane.setLayout(new FormLayout(new ColumnSpec[] {
					FormFactory.UNRELATED_GAP_COLSPEC, FormFactory.RELATED_GAP_COLSPEC,
					new ColumnSpec(ColumnSpec.FILL, Sizes.DEFAULT, FormSpec.DEFAULT_GROW),
					FormFactory.DEFAULT_COLSPEC, FormFactory.DEFAULT_COLSPEC,
					FormFactory.LABEL_COMPONENT_GAP_COLSPEC }, new RowSpec[] {
					FormFactory.PARAGRAPH_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC,
					FormFactory.RELATED_GAP_ROWSPEC,
					new RowSpec(RowSpec.FILL, Sizes.DEFAULT, FormSpec.NO_GROW),
					FormFactory.LINE_GAP_ROWSPEC,
					new RowSpec(RowSpec.CENTER, Sizes.DEFAULT, FormSpec.DEFAULT_GROW),
					FormFactory.PARAGRAPH_GAP_ROWSPEC }));
			((FormLayout) jHeaderPane.getLayout()).setColumnGroups(new int[][] { { 1, 6 } });

			// ---- jHTitleLbl ----
			jHTitleLbl.setName("jHTitleLbl");
			jHeaderPane.add(jHTitleLbl, cc.xywh(2, 2, 2, 1));

			// ---- jHTitleIcon ----
			jHTitleIcon
					.setIcon(new ImageIcon(getClass().getResource("/images/vlab/scenSample.gif")));
			jHTitleIcon.setName("jHTitleIcon");
			jHeaderPane.add(jHTitleIcon, cc.xywh(5, 2, 1, 5));

			// ---- jHTitleDescLbl ----
			jHTitleDescLbl.setName("jHTitleDescLbl");
			jHeaderPane.add(jHTitleDescLbl, cc.xy(3, 4));
		}
		contentPane.add(jHeaderPane, cc.xy(1, 1));

		// ======== jContentPane ========
		{
			jContentPane.setBorder(LineBorder.createBlackLineBorder());
			jContentPane.setName("jContentPane");
			jContentPane.setLayout(new FormLayout(new ColumnSpec[] {
					FormFactory.UNRELATED_GAP_COLSPEC, FormFactory.UNRELATED_GAP_COLSPEC,
					new ColumnSpec("left:max(pref;50dlu):grow(0.1)"),
					FormFactory.RELATED_GAP_COLSPEC,
					new ColumnSpec(ColumnSpec.FILL, Sizes.DEFAULT, FormSpec.DEFAULT_GROW),
					FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(Sizes.DLUX8) },
					new RowSpec[] { new RowSpec(RowSpec.FILL, Sizes.DLUY8, FormSpec.NO_GROW),
							FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC,
							FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC,
							new RowSpec(RowSpec.FILL, Sizes.dluY(50), FormSpec.NO_GROW),
							FormFactory.UNRELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC,
							FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC,
							FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC,
							FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC,
							FormFactory.PARAGRAPH_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC,
							new RowSpec(RowSpec.FILL, Sizes.DLUY8, FormSpec.NO_GROW) }));
			((FormLayout) jContentPane.getLayout()).setColumnGroups(new int[][] { { 1, 7 } });

			// ---- goodiesFormsSeparator1 ----
			goodiesFormsSeparator1.setName("goodiesFormsSeparator1");
			jContentPane.add(goodiesFormsSeparator1, cc.xywh(2, 2, 5, 1));

			// ---- jScenName ----
			jScenName.setName("jScenName");
			jContentPane.add(jScenName, cc.xy(3, 4));

			// ---- jNameTFld ----
			jNameTFld.setName("jNameTFld");
			jContentPane.add(jNameTFld, cc.xy(5, 4));

			// ---- jScenDesc ----
			jScenDesc.setName("jScenDesc");
			jContentPane.add(jScenDesc, cc.xy(3, 6));

			// ======== scrollPane1 ========
			{
				scrollPane1.setName("scrollPane1");

				// ---- jDescriptionTArea ----
				jDescriptionTArea.setColumns(10);
				jDescriptionTArea.setRows(4);
				jDescriptionTArea.setTabSize(4);
				jDescriptionTArea.setWrapStyleWord(true);
				jDescriptionTArea.setLineWrap(true);
				jDescriptionTArea.setName("jDescriptionTArea");
				scrollPane1.setViewportView(jDescriptionTArea);
			}
			jContentPane.add(scrollPane1, cc.xy(5, 6));

			// ---- jDatesTitle ----
			jDatesTitle.setName("jDatesTitle");
			jContentPane.add(jDatesTitle, cc.xywh(2, 8, 5, 1));

			// ---- jCreationDate ----
			jCreationDate.setName("jCreationDate");
			jContentPane.add(jCreationDate, cc.xy(3, 10));

			// ---- jCreationDateTFld ----
			jCreationDateTFld.setEditable(false);
			jCreationDateTFld.setHorizontalAlignment(SwingConstants.RIGHT);
			jCreationDateTFld.setName("jCreationDateTFld");
			jContentPane.add(jCreationDateTFld, cc.xy(5, 10));

			// ---- jScenModDate ----
			jScenModDate.setName("jScenModDate");
			jContentPane.add(jScenModDate, cc.xy(3, 12));

			// ---- jModificationDateTFld ----
			jModificationDateTFld.setEditable(false);
			jModificationDateTFld.setHorizontalAlignment(SwingConstants.RIGHT);
			jModificationDateTFld.setName("jModificationDateTFld");
			jContentPane.add(jModificationDateTFld, cc.xy(5, 12));

			// ---- jScenModifiedBy ----
			jScenModifiedBy.setName("jScenModifiedBy");
			jContentPane.add(jScenModifiedBy, cc.xy(3, 14));

			// ---- jModifiedByTFld ----
			jModifiedByTFld.setEditable(false);
			jModifiedByTFld.setHorizontalAlignment(SwingConstants.RIGHT);
			jModifiedByTFld.setName("jModifiedByTFld");
			jContentPane.add(jModifiedByTFld, cc.xy(5, 14));

			// ======== jButtonPane ========
			{
				jButtonPane.setMaximumSize(new Dimension(2147483647, 50));
				jButtonPane.setOpaque(false);
				jButtonPane.setName("jButtonPane");
				jButtonPane.setLayout(new FormLayout(new ColumnSpec[] {
						new ColumnSpec(ColumnSpec.FILL, Sizes.DEFAULT, FormSpec.DEFAULT_GROW),
						FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.BUTTON_COLSPEC,
						FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.BUTTON_COLSPEC },
						RowSpec.decodeSpecs("max(default;25dlu)")));

				// ---- jOkBtn ----
				jOkBtn.setText(bundle.getString("jscenario.properties.pane.jOkBtn.text"));
				jOkBtn.setIcon(new ImageIcon(getClass().getResource(
						"/images/eclipse/menu/save_single.gif")));
				jOkBtn.setMnemonic(bundle.getString("jscenario.properties.pane.jOkBtn.mnemonic")
						.charAt(0));
				jOkBtn.setName("jOkBtn");
				jOkBtn.addActionListener(new ActionListener() {
					public void actionPerformed(ActionEvent e) {
						jOkBtnActionPerformed(e);
					}
				});
				jButtonPane.add(jOkBtn, cc.xy(3, 1));

				// ---- jCancelBtn ----
				jCancelBtn.setText(bundle.getString("jscenario.properties.pane.jCancelBtn.text"));
				jCancelBtn.setIcon(new ImageIcon(getClass().getResource(
						"/images/edit/delete_edit.gif")));
				jCancelBtn.setMnemonic(bundle.getString(
						"jscenario.properties.pane.jCancelBtn.mnemonic").charAt(0));
				jCancelBtn.setName("jCancelBtn");
				jCancelBtn.addActionListener(new ActionListener() {
					public void actionPerformed(ActionEvent e) {
						jCancelBtnActionPerformed(e);
					}
				});
				jButtonPane.add(jCancelBtn, cc.xy(5, 1));
			}
			jContentPane.add(jButtonPane, cc.xywh(1, 16, 5, 1));
		}
		contentPane.add(jContentPane, cc.xy(1, 3));
		pack();
		setLocationRelativeTo(getOwner());
		// //GEN-END:initComponents
	}

	// JFormDesigner - Variables declaration - DO NOT MODIFY
	// //GEN-BEGIN:variables
	// Generated using JFormDesigner non-commercial license
	private JAbstractHeaderPane jHeaderPane;
	private JLabel jHTitleLbl;
	private JLabel jHTitleIcon;
	private JLabel jHTitleDescLbl;
	private JGenericPane jContentPane;
	private JComponent goodiesFormsSeparator1;
	private JLabel jScenName;
	private JTextField jNameTFld;
	private JLabel jScenDesc;
	private JScrollPane scrollPane1;
	private JTextArea jDescriptionTArea;
	private JComponent jDatesTitle;
	private JLabel jCreationDate;
	private JTextField jCreationDateTFld;
	private JLabel jScenModDate;
	private JTextField jModificationDateTFld;
	private JLabel jScenModifiedBy;
	private JTextField jModifiedByTFld;
	private JPanel jButtonPane;
	private JButton jOkBtn;
	private JButton jCancelBtn;

	// JFormDesigner - End of variables declaration //GEN-END:variables

	// ----------------------------------------------------------------------------------
	// ---- Private Helper Methods

	/**
	 * Handles OK action
	 * 
	 * @param e instance of {@link ActionEvent}
	 */
	private void jOkBtnActionPerformed(ActionEvent e) {
		update();
		setVisible(false);
		dispose();
	}

	/**
	 * Handles Cancel action
	 * 
	 * @param e instance of {@link ActionEvent}
	 */
	private void jCancelBtnActionPerformed(ActionEvent e) {
		setVisible(false);
		dispose();
	}

	/**
	 * Update the ScenarioDocument with the user provided values
	 */
	private void update() {
		String name = jNameTFld.getText();
		experimentInfo.setName(name);
		experimentInfo.setDescription(jDescriptionTArea.getText());
	}

	/**
	 * Initialises custom form components
	 */
	private void initForm() {
		FormHelper.setNormalizedDocument(jNameTFld, 50);
		FormHelper.setNormalizedDocument(jDescriptionTArea, 150);
		// init values
		String value = experimentInfo != null ? experimentInfo.getName() : "";
		jNameTFld.setText(value);

		value = experimentInfo != null ? experimentInfo.getDescription() : "";
		jDescriptionTArea.setText(value);

		value = experimentInfo != null ? experimentInfo.getCreationDate() : "";
		jCreationDateTFld.setText(value);

		value = experimentInfo != null ? experimentInfo.getUserName() : "";
		jModifiedByTFld.setText(value);
	}

	// --------------------------------------------------------------------------
	// ----- Setters / Getters

	/**
	 * Get value of field: experimentInfo
	 * 
	 * @return the experimentInfo
	 */
	public ExperimentInfo getExperimentInfo() {
		return experimentInfo;
	}
}
