package pl.psnc.expres.wfm.gui.scenario;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;

import pl.psnc.expres.model.experiment.ExperimentInfo;
import pl.psnc.expres.model.factory.VlbiExperimentFactory;
import pl.psnc.expres.wfm.gui.JAbstractHeaderPane;
import pl.psnc.expres.wfm.gui.main.JMainFrame;
import pl.psnc.vlab.util.gui.helper.FormHelper;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.DefaultComponentFactory;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpec;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Sizes;
import com.jgoodies.uif_lite.panel.SimpleInternalFrame;

/**
 * {@link JScenarioDetailsPane} class - scenario details pane
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public class JScenarioDetailsPane extends SimpleInternalFrame {

	/** Stores instance of field: serialVersionUID */
	private static final long serialVersionUID = 1L;

	/** Instance of the scenario description */
	private ExperimentInfo experimentInfo;

	/**
	 * Creates new Scenario Details Pane (Part of Resource Info Perspective)
	 */
	public JScenarioDetailsPane() {
		this(VlbiExperimentFactory.getInstance().getInfo());
	}

	/**
	 * Creates new Scenario Details Pane (Part of Resource Info Perspective)
	 * 
	 * @param scenario scenario details
	 */
	public JScenarioDetailsPane(ExperimentInfo experimentInfo) {
		initComponents();
		this.experimentInfo = experimentInfo;
		jDefineTitleSeparator.setForeground(Color.ORANGE);
		jEditTitleSeparator.setForeground(Color.ORANGE);
		setFields();
	}

	/**
	 * Initialises form components
	 */
	private void initComponents() {
		// JFormDesigner - Component initialization - DO NOT
		// MODIFY//GEN-BEGIN:initComponents
		// Generated using JFormDesigner non-commercial license
		ResourceBundle bundle = ResourceBundle.getBundle("bundle.gui");
		DefaultComponentFactory compFactory = DefaultComponentFactory.getInstance();
		jScrollPane = new JScrollPane();
		jContentPane = new JAbstractHeaderPane();
		jExpInfotNotAvailablePane = new JPanel();
		jScenDetailsTitle = compFactory.createSeparator(bundle
				.getString("jscenario.details.pane.jScenDetailsTitle.text"));
		jDetailsNotDefLbl = compFactory.createLabel(bundle
				.getString("jscenario.details.pane.jDetailsNotDefLbl.textWithMnemonic"));
		jDefineTitleSeparator = compFactory.createSeparator("");
		jDefineBtn = new JButton();
		jExpInfoPane = new JPanel();
		jScenNameTitle = compFactory.createSeparator(bundle
				.getString("jscenario.details.pane.jScenNameTitle.text"));
		jScenNameVal = new JTextField();
		jScenDescTitle = compFactory.createSeparator(bundle
				.getString("jscenario.details.pane.jScenDescTitle.text"));
		jScenDescVal = new JTextArea();
		jScenCreatedByTitle = compFactory.createSeparator(bundle
				.getString("jscenario.details.pane.jScenCreatedByTitle.text"));
		jScenCreatedByVal = new JTextField();
		jEditTitleSeparator = compFactory.createSeparator(" ");
		jEditBtn = new JButton();
		jResourceToolBar = new JToolBar();
		jRICloseBtn = new JButton();
		CellConstraints cc = new CellConstraints();

		// ======== this ========
		setPreferredSize(new Dimension(200, 300));
		setTitle(bundle.getString("jscenario.details.pane.this.title"));
		setFrameIcon(new ImageIcon(getClass().getResource("/images/buttons/outline_co.gif")));
		setName("this");
		Container contentPane = getContentPane();
		contentPane.setLayout(new FormLayout("default:grow", "fill:default:grow"));

		// ======== jScrollPane ========
		{
			jScrollPane.setBorder(Borders.createEmptyBorder("0dlu, 0dlu, 0dlu, 0dlu"));
			jScrollPane.setName("jScrollPane");

			// ======== jContentPane ========
			{
				jContentPane.setBorder(Borders.createEmptyBorder("0dlu, 0dlu, 0dlu, 0dlu"));
				jContentPane.setName("jContentPane");
				jContentPane.setLayout(new FormLayout(ColumnSpec.decodeSpecs("default:grow"),
						new RowSpec[] { new RowSpec(RowSpec.FILL, Sizes.DLUY8, FormSpec.NO_GROW),
								FormFactory.DEFAULT_ROWSPEC,
								new RowSpec(RowSpec.FILL, Sizes.DEFAULT, FormSpec.DEFAULT_GROW),
								new RowSpec(RowSpec.FILL, Sizes.DLUY8, FormSpec.NO_GROW) }));

				// ======== jExpInfotNotAvailablePane ========
				{
					jExpInfotNotAvailablePane.setOpaque(false);
					jExpInfotNotAvailablePane.setRequestFocusEnabled(false);
					jExpInfotNotAvailablePane.setName("jExpInfotNotAvailablePane");
					jExpInfotNotAvailablePane.setLayout(new FormLayout(new ColumnSpec[] {
							new ColumnSpec(Sizes.DLUX8), new ColumnSpec(Sizes.DLUX7),
							new ColumnSpec(ColumnSpec.FILL, Sizes.MINIMUM, FormSpec.DEFAULT_GROW),
							FormFactory.BUTTON_COLSPEC, new ColumnSpec(Sizes.DLUX8) },
							new RowSpec[] { FormFactory.DEFAULT_ROWSPEC,
									FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC,
									FormFactory.PARAGRAPH_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC,
									FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC,
									new RowSpec(RowSpec.FILL, Sizes.DLUY8, FormSpec.NO_GROW) }));
					((FormLayout) jExpInfotNotAvailablePane.getLayout())
							.setColumnGroups(new int[][] { { 1, 5 } });

					// ---- jScenDetailsTitle ----
					jScenDetailsTitle.setName("jScenDetailsTitle");
					jExpInfotNotAvailablePane.add(jScenDetailsTitle, cc.xywh(2, 1, 3, 1));

					// ---- jDetailsNotDefLbl ----
					jDetailsNotDefLbl.setName("jDetailsNotDefLbl");
					jExpInfotNotAvailablePane.add(jDetailsNotDefLbl, cc.xywh(3, 3, 2, 1));

					// ---- jDefineTitleSeparator ----
					jDefineTitleSeparator.setName("jDefineTitleSeparator");
					jExpInfotNotAvailablePane.add(jDefineTitleSeparator, cc.xywh(2, 5, 3, 1));

					// ---- jDefineBtn ----
					jDefineBtn.setText(bundle.getString("jscenario.details.pane.jDefineBtn.text"));
					jDefineBtn.setIcon(new ImageIcon(getClass().getResource(
							"/images/eclipse/menu/segment_edit.gif")));
					jDefineBtn.setToolTipText(bundle
							.getString("jscenario.details.pane.jDefineBtn.toolTipText"));
					jDefineBtn.setName("jDefineBtn");
					jDefineBtn.addActionListener(new ActionListener() {
						public void actionPerformed(ActionEvent e) {
							jDefineBtnActionPerformed(e);
						}
					});
					jExpInfotNotAvailablePane.add(jDefineBtn, cc.xy(4, 7));
				}
				jContentPane.add(jExpInfotNotAvailablePane, cc.xy(1, 2));

				// ======== jExpInfoPane ========
				{
					jExpInfoPane.setPreferredSize(new Dimension(200, 300));
					jExpInfoPane.setOpaque(false);
					jExpInfoPane.setName("jExpInfoPane");
					jExpInfoPane.setLayout(new FormLayout(new ColumnSpec[] {
							FormFactory.UNRELATED_GAP_COLSPEC, new ColumnSpec(Sizes.DLUX7),
							new ColumnSpec(ColumnSpec.FILL, Sizes.MINIMUM, FormSpec.DEFAULT_GROW),
							FormFactory.BUTTON_COLSPEC, FormFactory.UNRELATED_GAP_COLSPEC },
							new RowSpec[] { FormFactory.DEFAULT_ROWSPEC,
									FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC,
									FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC,
									FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC,
									FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC,
									FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC,
									FormFactory.PARAGRAPH_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC,
									FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC,
									FormFactory.UNRELATED_GAP_ROWSPEC }));
					((FormLayout) jExpInfoPane.getLayout())
							.setColumnGroups(new int[][] { { 1, 5 } });

					// ---- jScenNameTitle ----
					jScenNameTitle.setName("jScenNameTitle");
					jExpInfoPane.add(jScenNameTitle, cc.xywh(2, 1, 3, 1));

					// ---- jScenNameVal ----
					jScenNameVal.setEditable(false);
					jScenNameVal.setOpaque(false);
					jScenNameVal.setText("name");
					jScenNameVal.setBorder(Borders.createEmptyBorder("0dlu, 0dlu, 0dlu, 0dlu"));
					jScenNameVal.setName("jScenNameVal");
					jExpInfoPane.add(jScenNameVal, cc.xywh(3, 3, 2, 1));

					// ---- jScenDescTitle ----
					jScenDescTitle.setName("jScenDescTitle");
					jExpInfoPane.add(jScenDescTitle, cc.xywh(2, 5, 3, 1));

					// ---- jScenDescVal ----
					jScenDescVal.setColumns(10);
					jScenDescVal.setRows(4);
					jScenDescVal.setText("desc");
					jScenDescVal.setBorder(Borders.createEmptyBorder("0dlu, 0dlu, 0dlu, 0dlu"));
					jScenDescVal.setOpaque(false);
					jScenDescVal.setName("jScenDescVal");
					jExpInfoPane.add(jScenDescVal, cc.xywh(3, 7, 2, 1));

					// ---- jScenCreatedByTitle ----
					jScenCreatedByTitle.setName("jScenCreatedByTitle");
					jExpInfoPane.add(jScenCreatedByTitle, cc.xywh(2, 9, 3, 1));

					// ---- jScenCreatedByVal ----
					jScenCreatedByVal.setEditable(false);
					jScenCreatedByVal
							.setBorder(Borders.createEmptyBorder("0dlu, 0dlu, 0dlu, 0dlu"));
					jScenCreatedByVal.setOpaque(false);
					jScenCreatedByVal.setText("autor");
					jScenCreatedByVal.setName("jScenCreatedByVal");
					jExpInfoPane.add(jScenCreatedByVal, cc.xywh(3, 11, 2, 1));

					// ---- jEditTitleSeparator ----
					jEditTitleSeparator.setName("jEditTitleSeparator");
					jExpInfoPane.add(jEditTitleSeparator, cc.xywh(2, 13, 3, 1));

					// ---- jEditBtn ----
					jEditBtn.setText(bundle.getString("jscenario.details.pane.jEditBtn.text"));
					jEditBtn.setIcon(new ImageIcon(getClass().getResource(
							"/images/eclipse/menu/segment_edit.gif")));
					jEditBtn.setToolTipText(bundle
							.getString("jscenario.details.pane.jEditBtn.toolTipText"));
					jEditBtn.setName("jEditBtn");
					jEditBtn.addActionListener(new ActionListener() {
						public void actionPerformed(ActionEvent e) {
							jEditBtnActionPerformed(e);
						}
					});
					jExpInfoPane.add(jEditBtn, cc.xy(4, 15));
				}
				jContentPane.add(jExpInfoPane, cc.xy(1, 3));
			}
			jScrollPane.setViewportView(jContentPane);
		}
		contentPane.add(jScrollPane, cc.xy(1, 1));

		// ======== jResourceToolBar ========
		{
			jResourceToolBar.setEnabled(false);
			jResourceToolBar.setRollover(true);
			jResourceToolBar.setFloatable(false);
			jResourceToolBar.setName("jResourceToolBar");

			// ---- jRICloseBtn ----
			jRICloseBtn.setIcon(new ImageIcon(getClass().getResource(
					"/images/buttons/remove_att.gif")));
			jRICloseBtn.setRolloverIcon(new ImageIcon(getClass().getResource(
					"/images/buttons/delete_obj.gif")));
			jRICloseBtn.setSelectedIcon(null);
			jRICloseBtn.setFocusable(false);
			jRICloseBtn.setName("jRICloseBtn");
			jResourceToolBar.add(jRICloseBtn);
		}
		// initialization//GEN-END:initComponents
	}

	// JFormDesigner - Variables declaration - DO NOT
	// MODIFY//GEN-BEGIN:variables
	// Generated using JFormDesigner non-commercial license
	private JScrollPane jScrollPane;
	private JAbstractHeaderPane jContentPane;
	private JPanel jExpInfotNotAvailablePane;
	private JComponent jScenDetailsTitle;
	private JLabel jDetailsNotDefLbl;
	private JComponent jDefineTitleSeparator;
	private JButton jDefineBtn;
	private JPanel jExpInfoPane;
	private JComponent jScenNameTitle;
	private JTextField jScenNameVal;
	private JComponent jScenDescTitle;
	private JTextArea jScenDescVal;
	private JComponent jScenCreatedByTitle;
	private JTextField jScenCreatedByVal;
	private JComponent jEditTitleSeparator;
	private JButton jEditBtn;
	private JToolBar jResourceToolBar;
	private JButton jRICloseBtn;

	// JFormDesigner - End of variables declaration//GEN-END:variables

	
	// ----------------------------------------------------------------------------------
	// ----  Helper Methods

	public void update(){
		setFields();
	}
	
	// ----------------------------------------------------------------------------------
	// ---- Private Helper Methods

	/**
	 * Handles Define button
	 * 
	 * @param e instance of {@link ActionEvent}
	 */
	private void jDefineBtnActionPerformed(ActionEvent e) {
		showPropertiesDialog();
	}

	/**
	 * Handles Edit button
	 * 
	 * @param e instance of {@link ActionEvent}
	 */
	private void jEditBtnActionPerformed(ActionEvent e) {
		showPropertiesDialog();
	}

	/**
	 * Shows scenario properties dialog
	 */
	private void showPropertiesDialog() {
		JScenarioPropertiesPane scenarioPropertiesPane = new JScenarioPropertiesPane(JMainFrame
				.getInstance(), experimentInfo);
		scenarioPropertiesPane.setVisible(true);
		setFields();
	}

	/**
	 * Set the frame fields to the values from the ScenarioDocument
	 */
	private void setFields() {
		boolean infoDefined = experimentInfo != null ? !FormHelper.isNull(experimentInfo.getName())
				: false;

		jExpInfoPane.setVisible(infoDefined);
		jExpInfotNotAvailablePane.setVisible(!infoDefined);

		jScenNameVal.setText(experimentInfo != null ? experimentInfo.getName() : "");
		jScenDescVal.setText(experimentInfo != null ? experimentInfo.getDescription() : "");
		jScenCreatedByVal.setText(experimentInfo != null ? experimentInfo.getUserName() : "");
	}

}
