/*
 * ListBoxDefaultRenderer.java
 *
 * Created on 7 lipiec 2004, 16:37
 */

package pl.psnc.expres.wfm.gui.resource.renderer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;

import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import pl.psnc.vlab.util.swing.gui.ColorKeys;

/**
 *
 * @author  Dominik Stoklosa
 * @email  osa@man.poznan.pl
 */
public class ListBoxDefaultRenderer extends DefaultListCellRenderer{
    
    private final static Color LINE_NUMBERS_FONT_COLOR = new Color(128, 64, 64);
    private final static Color LINE_NUMBERS_BG_COLOR   = new Color(224, 224, 224);    
    
    
    /** Logger instance */
    private Log log = LogFactory.getLog(this.getClass().getName());
       
    /** Stores the cell border inset */
    private final int cellBorderInset;
    /** Stores the cell base line. font size and border */
    private final int baseline;
    /** Stores the cell width */
    private final int width;
    /** Stores the cell height */
    private final int height;
    
    /** Stores the list property */
    private final JList list;
    /** Stores the selected property */
    private boolean isSelected;
    /** Stores the cell value of the given list */
    private String text = null;
    /** Stores the cell index */
    private String index;
    
    /** Holds value of property line letter width. */
    private int lineLetterWidth;
    /** Holds value of property line numbers width. */
    private int lineFieldWidth;
    
    public ListBoxDefaultRenderer(JList list, int cellBorderInset, int width){
        this.list = list;        
        this.cellBorderInset = cellBorderInset;
        FontMetrics metrics = list.getFontMetrics(list.getFont());
        this.baseline = metrics.getAscent() + cellBorderInset;
        this.height = metrics.getHeight() + (2 * cellBorderInset);
        this.width = width;                      
    }
    
    /**
     * Return the renderers fixed size here.
     */
    public Dimension getPreferredSize() {
        return new Dimension(width, height);
    }
    
    
    /**
     * Return a component that has been configured to display the specified
     * value. That component's <code>paint</code> method is then called to
     * "render" the cell.  If it is necessary to compute the dimensions
     * of a list because the list cells do not have a fixed size, this method
     * is called to generate a component on which <code>getPreferredSize</code>
     * can be invoked.
     *
     * @param list The JList we're painting.
     * @param value The value returned by list.getModel().getElementAt(index).
     * @param index The cells index.
     * @param isSelected True if the specified cell was selected.
     * @param cellHasFocus True if the specified cell has the focus.
     * @return A component whose paint() method will render the specified value.
     *
     * @see JList
     * @see ListSelectionModel
     * @see ListModel
     */
    public java.awt.Component getListCellRendererComponent(javax.swing.JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if(isSelected){
            setBackground(ColorKeys.COLOR_ADDED_LIGHT_GREEN);
            setForeground(list.getSelectionForeground());            
        } else {
            setBackground(list.getBackground());
            setForeground(list.getForeground());
        }
        this.text = value.toString();
        this.index = String.valueOf(index);
        this.isSelected = isSelected;
        return this;
    }
    
    
    
    /**
     * Paints this component.
     * <p>
     * This method is called when the contents of the component should
     * be painted; such as when the component is first being shown or
     * is damaged and in need of repair.  The clip rectangle in the
     * <code>Graphics</code> parameter is set to the area
     * which needs to be painted.
     * Subclasses of <code>Component</code> that override this
     * method need not call <code>super.paint(g)</code>.
     * <p>
     * For performance reasons, <code>Component</code>s with zero width
     * or height aren't considered to need painting when they are first shown,
     * and also aren't considered to need repair.
     * <p>
     * <b>Note</b>: For more information on the paint mechanisms utilitized
     * by AWT and Swing, including information on how to write the most
     * efficient painting code, see
     * <a href="http://java.sun.com/products/jfc/tsc/articles/painting/index.html">Painting in AWT and Swing</a>.
     *
     * @param g the graphics context to use for painting
     * @see       #update
     * @since     JDK1.0
     */
    public void paint(java.awt.Graphics g) {
        if(this.isSelected){
            g.setColor(getBackground());
            g.fillRect(0, 0, getWidth(), getHeight());
        }
        g.setColor(getForeground());
        g.drawString(text, cellBorderInset + lineFieldWidth+10, baseline);          //draw the text
        
        g.setColor(LINE_NUMBERS_BG_COLOR);
        g.fillRect(0, 0, cellBorderInset +lineFieldWidth+5, getHeight());         //draw backgroung
        
        g.setColor(LINE_NUMBERS_FONT_COLOR);
        g.setFont(list.getFont());
        g.drawString(index, lineFieldWidth- (index.length()*lineLetterWidth) , baseline);           //draw the line numbers
        
        g.setColor(Color.black);
        g.drawLine(lineFieldWidth+5, 0, lineFieldWidth+5, getHeight());
    }
    
    
    /**
     * Update the list renderer. This method should be called when data model has changed 
     * and the list has to be repainted
     * @param maxIndex
     */    
    public void update(int maxIndex){
        FontMetrics metrics = list.getFontMetrics(list.getFont());
        this.lineLetterWidth = (int) metrics.getStringBounds("7", list.getGraphics()).getWidth();
        int maxLength = String.valueOf(maxIndex).length();        
        this.lineFieldWidth = lineLetterWidth * maxLength;        
    }
    
    
}
