/*
 * NumberDocument.java
 *
 * Created on 9 lipiec 2004, 13:20
 */

package pl.psnc.expres.wfm.gui.resource.document;

import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import pl.psnc.vlab.util.FormTools;

/**
 *  The Document is a container for text that serves as the model for swing text components.
 * The document accepts only the number characters
 * @author  Dominik Stoklosa
 * @email  osa@man.poznan.pl
 */
public class NumberDocument extends PlainDocument{
    
    /** Logger instance */
    public Log log = LogFactory.getLog(this.getClass().getName());
    
    /** Creates a new instance of NumberDocument */
    public NumberDocument() {
    }
    
    /**
     * Inserts a string of content.  This will cause a DocumentEvent
     * of type DocumentEvent.EventType.INSERT to be sent to the
     * registered DocumentListers, unless an exception is thrown.
     * The DocumentEvent will be delivered by calling the
     * insertUpdate method on the DocumentListener.
     * The offset and length of the generated DocumentEvent
     * will indicate what change was actually made to the Document.
     * <p align=center><img src="doc-files/Document-insert.gif"
     *  alt="Diagram shows insertion of 'quick' in 'The quick brown fox'">
     * <p>
     * If the Document structure changed as result of the insertion,
     * the details of what Elements were inserted and removed in
     * response to the change will also be contained in the generated
     * DocumentEvent.  It is up to the implementation of a Document
     * to decide how the structure should change in response to an
     * insertion.
     * <p>
     * If the Document supports undo/redo, an UndoableEditEvent will
     * also be generated.
     *
     * @param offset  the offset into the document to insert the content >= 0.
     *    All positions that track change at or after the given location
     *    will move.
     * @param str    the string to insert
     * @param a      the attributes to associate with the inserted
     *   content.  This may be null if there are no attributes.
     * @exception BadLocationException  the given insert position is not a valid
     * position within the document
     * @see javax.swing.event.DocumentEvent
     * @see javax.swing.event.DocumentListener
     * @see javax.swing.event.UndoableEditEvent
     * @see javax.swing.event.UndoableEditListener
     */
    public void insertString(int offset, String str, javax.swing.text.AttributeSet a) throws javax.swing.text.BadLocationException {        
        if(offset == 0 && str.equals("-")){
            super.insertString(offset, str, a);
            return;
        }
        if(str.trim().equals("")){            
            return;
        }
        int length = getLength();
        StringBuffer textValue = new StringBuffer(length+str.length());
        if(offset >= length){
            textValue.append(getText(0, length ))
            .append(str);
        } else {
            textValue.append(getText(0, offset))
            .append(str)
            .append(getText(offset, length-offset+1));
        }                
                
        if(!FormTools.isValidateStringDouble(textValue.toString()) ){        
            return;
        }
        super.insertString(offset, str, a);
        return;
    }
}
