/*
 * Created by JFormDesigner on Fri Dec 29 11:54:53 CET 2006
 */

package pl.psnc.expres.wfm.gui.resource;

import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingConstants;
import javax.swing.border.LineBorder;

import pl.psnc.vlab.util.gui.frame.GenericGradientPane;
import pl.psnc.vlab.util.swing.gui.ColorKeys;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.DefaultComponentFactory;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpec;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Sizes;

/**
 * @author Dominik Stoklosa
 */
public class JRadioPropertiesTemplate extends JDialog {
    public JRadioPropertiesTemplate(Frame owner) {
        super(owner);
        initComponents();
    }
    
    public JRadioPropertiesTemplate(Dialog owner) {
        super(owner);
        initComponents();
    }
    
    private void jOkBtnActionPerformed(ActionEvent e) {
        setVisible(false);
        dispose();        
    }
    
    private void jCancelBtnActionPerformed(ActionEvent e) {
        setVisible(false);
        dispose();        
    }
    
    private void initComponents() {
		// JFormDesigner - Component initialization - DO NOT MODIFY//GEN-BEGIN:initComponents
		// Generated using JFormDesigner non-commercial license
		DefaultComponentFactory compFactory = DefaultComponentFactory.getInstance();
		jHeaderPane = new GenericGradientPane(ColorKeys.GRADIENT_PANE_HEADER[0], ColorKeys.GRADIENT_PANE_HEADER[1]);
		jHTitleLbl = compFactory.createTitle("Resource Properties");
		jHTitleIcon = new JLabel();
		jHTitleDescLbl = compFactory.createLabel("The dialog presents the list of resource properties");
		jContentPane = new JPanel();
		jPropertyTabs = new JTabbedPane();
		scrollPane2 = new JScrollPane();
		jGenInfoPane = new JPanel();
		goodiesFormsSeparator1 = compFactory.createSeparator("Resource");
		jScenName = new JLabel();
		jScenNameVal = new JTextField();
		jOwner = new JLabel();
		jOwnerValue = new JTextField();
		jOwner2 = new JLabel();
		jOwnerValue2 = new JTextField();
		jScenDesc = new JLabel();
		scrollPane1 = new JScrollPane();
		jScenDescVal = new JTextArea();
		jDatesTitle = compFactory.createSeparator("Image");
		jResImage = new JLabel();
		jButtonPane = new JPanel();
		jOkBtn = new JButton();
		jCancelBtn = new JButton();
		CellConstraints cc = new CellConstraints();

		//======== this ========
		setModal(true);
		Container contentPane = getContentPane();
		contentPane.setLayout(new FormLayout(
			ColumnSpec.decodeSpecs("default:grow"),
			new RowSpec[] {
				new RowSpec(RowSpec.FILL, Sizes.dluY(72), FormSpec.NO_GROW),
				FormFactory.LINE_GAP_ROWSPEC,
				new RowSpec(RowSpec.FILL, Sizes.DEFAULT, FormSpec.DEFAULT_GROW),
				FormFactory.LINE_GAP_ROWSPEC
			}));

		//======== jHeaderPane ========
		{
			jHeaderPane.setBorder(LineBorder.createBlackLineBorder());
			jHeaderPane.setLayout(new FormLayout(
				new ColumnSpec[] {
					FormFactory.UNRELATED_GAP_COLSPEC,
					FormFactory.RELATED_GAP_COLSPEC,
					new ColumnSpec(ColumnSpec.FILL, Sizes.DEFAULT, FormSpec.DEFAULT_GROW),
					FormFactory.DEFAULT_COLSPEC,
					FormFactory.DEFAULT_COLSPEC,
					FormFactory.LABEL_COMPONENT_GAP_COLSPEC
				},
				new RowSpec[] {
					FormFactory.PARAGRAPH_GAP_ROWSPEC,
					FormFactory.DEFAULT_ROWSPEC,
					FormFactory.RELATED_GAP_ROWSPEC,
					new RowSpec(RowSpec.FILL, Sizes.DEFAULT, FormSpec.NO_GROW),
					FormFactory.LINE_GAP_ROWSPEC,
					new RowSpec(RowSpec.CENTER, Sizes.DEFAULT, FormSpec.DEFAULT_GROW),
					FormFactory.PARAGRAPH_GAP_ROWSPEC
				}));
			((FormLayout)jHeaderPane.getLayout()).setColumnGroups(new int[][] {{1, 6}});
			jHeaderPane.add(jHTitleLbl, cc.xywh(2, 2, 2, 1));

			//---- jHTitleIcon ----
			jHTitleIcon.setIcon(new ImageIcon(getClass().getResource("/images/graph/radio_telescope.png")));
			jHeaderPane.add(jHTitleIcon, cc.xywh(5, 2, 1, 5));
			jHeaderPane.add(jHTitleDescLbl, cc.xy(3, 4));
		}
		contentPane.add(jHeaderPane, cc.xy(1, 1));

		//======== jContentPane ========
		{
			jContentPane.setPreferredSize(new Dimension(450, 400));
			jContentPane.setMinimumSize(new Dimension(264, 150));
			jContentPane.setLayout(new FormLayout(
				new ColumnSpec[] {
					FormFactory.RELATED_GAP_COLSPEC,
					new ColumnSpec(ColumnSpec.FILL, Sizes.DEFAULT, FormSpec.DEFAULT_GROW),
					FormFactory.RELATED_GAP_COLSPEC
				},
				new RowSpec[] {
					new RowSpec(RowSpec.FILL, Sizes.DEFAULT, FormSpec.DEFAULT_GROW),
					FormFactory.PARAGRAPH_GAP_ROWSPEC,
					FormFactory.DEFAULT_ROWSPEC,
					FormFactory.PARAGRAPH_GAP_ROWSPEC
				}));
			((FormLayout)jContentPane.getLayout()).setColumnGroups(new int[][] {{1, 3}});

			//======== jPropertyTabs ========
			{
				jPropertyTabs.setPreferredSize(new Dimension(300, 60));

				//======== scrollPane2 ========
				{
					scrollPane2.setBorder(Borders.createEmptyBorder("0dlu, 0dlu, 0dlu, 0dlu"));

					//======== jGenInfoPane ========
					{
						jGenInfoPane.setLayout(new FormLayout(
							new ColumnSpec[] {
								FormFactory.UNRELATED_GAP_COLSPEC,
								FormFactory.RELATED_GAP_COLSPEC,
								new ColumnSpec("right:max(pref;30dlu):grow(0.1)"),
								FormFactory.UNRELATED_GAP_COLSPEC,
								new ColumnSpec("max(default;105dlu)"),
								new ColumnSpec(ColumnSpec.FILL, Sizes.DEFAULT, FormSpec.DEFAULT_GROW),
								FormFactory.LABEL_COMPONENT_GAP_COLSPEC,
								FormFactory.UNRELATED_GAP_COLSPEC
							},
							new RowSpec[] {
								FormFactory.LINE_GAP_ROWSPEC,
								FormFactory.DEFAULT_ROWSPEC,
								FormFactory.LINE_GAP_ROWSPEC,
								FormFactory.DEFAULT_ROWSPEC,
								FormFactory.LINE_GAP_ROWSPEC,
								FormFactory.DEFAULT_ROWSPEC,
								FormFactory.LINE_GAP_ROWSPEC,
								FormFactory.DEFAULT_ROWSPEC,
								FormFactory.LINE_GAP_ROWSPEC,
								new RowSpec(RowSpec.FILL, Sizes.dluY(50), FormSpec.NO_GROW),
								FormFactory.UNRELATED_GAP_ROWSPEC,
								FormFactory.DEFAULT_ROWSPEC,
								FormFactory.UNRELATED_GAP_ROWSPEC,
								FormFactory.DEFAULT_ROWSPEC,
								FormFactory.RELATED_GAP_ROWSPEC,
								FormFactory.DEFAULT_ROWSPEC,
								FormFactory.LINE_GAP_ROWSPEC,
								FormFactory.DEFAULT_ROWSPEC,
								new RowSpec("fill:min(default;20dlu):grow")
							}));
						((FormLayout)jGenInfoPane.getLayout()).setColumnGroups(new int[][] {{1, 8}});
						jGenInfoPane.add(goodiesFormsSeparator1, cc.xywh(2, 2, 6, 1));

						//---- jScenName ----
						jScenName.setText("Name");
						jGenInfoPane.add(jScenName, cc.xy(3, 4));

						//---- jScenNameVal ----
						jScenNameVal.setText("RT-4 Radio telescope");
						jScenNameVal.setFont(new Font("Dialog", Font.PLAIN, 11));
						jGenInfoPane.add(jScenNameVal, cc.xy(5, 4));

						//---- jOwner ----
						jOwner.setText("Owner");
						jGenInfoPane.add(jOwner, cc.xy(3, 6));

						//---- jOwnerValue ----
						jOwnerValue.setText("Nicolaus Copernicus University");
						jOwnerValue.setFont(new Font("Dialog", Font.PLAIN, 11));
						jGenInfoPane.add(jOwnerValue, cc.xy(5, 6));

						//---- jOwner2 ----
						jOwner2.setText("Location");
						jGenInfoPane.add(jOwner2, cc.xy(3, 8));

						//---- jOwnerValue2 ----
						jOwnerValue2.setText("Torun, Poland");
						jOwnerValue2.setFont(new Font("Dialog", Font.PLAIN, 11));
						jGenInfoPane.add(jOwnerValue2, cc.xy(5, 8));

						//---- jScenDesc ----
						jScenDesc.setText("Description");
						jGenInfoPane.add(jScenDesc, cc.xy(3, 10));

						//======== scrollPane1 ========
						{

							//---- jScenDescVal ----
							jScenDescVal.setColumns(10);
							jScenDescVal.setRows(4);
							jScenDescVal.setTabSize(4);
							jScenDescVal.setWrapStyleWord(true);
							jScenDescVal.setLineWrap(true);
							jScenDescVal.setFont(new Font("Dialog", Font.PLAIN, 11));
							scrollPane1.setViewportView(jScenDescVal);
						}
						jGenInfoPane.add(scrollPane1, cc.xywh(5, 10, 2, 1));
						jGenInfoPane.add(jDatesTitle, cc.xywh(2, 12, 6, 1));

						//---- jResImage ----
						jResImage.setIcon(new ImageIcon(getClass().getResource("/images/map/z_Torun.png")));
						jResImage.setHorizontalAlignment(SwingConstants.CENTER);
						jGenInfoPane.add(jResImage, cc.xywh(3, 14, 4, 1));
					}
					scrollPane2.setViewportView(jGenInfoPane);
				}
				jPropertyTabs.addTab("General information", scrollPane2);

			}
			jContentPane.add(jPropertyTabs, cc.xy(2, 1));

			//======== jButtonPane ========
			{
				jButtonPane.setMaximumSize(new Dimension(2147483647, 50));
				jButtonPane.setLayout(new FormLayout(
					new ColumnSpec[] {
						new ColumnSpec(ColumnSpec.FILL, Sizes.DEFAULT, FormSpec.DEFAULT_GROW),
						FormFactory.LABEL_COMPONENT_GAP_COLSPEC,
						FormFactory.BUTTON_COLSPEC,
						FormFactory.LABEL_COMPONENT_GAP_COLSPEC,
						FormFactory.BUTTON_COLSPEC
					},
					RowSpec.decodeSpecs("max(default;25dlu)")));

				//---- jOkBtn ----
				jOkBtn.setText("OK");
				jOkBtn.setIcon(new ImageIcon(getClass().getResource("/images/buttons/ok.gif")));
				jOkBtn.addActionListener(new ActionListener() {
					public void actionPerformed(ActionEvent e) {
						jOkBtnActionPerformed(e);
						jOkBtnActionPerformed(e);
					}
				});
				jButtonPane.add(jOkBtn, cc.xy(3, 1));

				//---- jCancelBtn ----
				jCancelBtn.setText("Cancel");
				jCancelBtn.setIcon(new ImageIcon(getClass().getResource("/images/buttons/delete_obj.gif")));
				jCancelBtn.addActionListener(new ActionListener() {
					public void actionPerformed(ActionEvent e) {
						jCancelBtnActionPerformed(e);
						jCancelBtnActionPerformed(e);
					}
				});
				jButtonPane.add(jCancelBtn, cc.xy(5, 1));
			}
			jContentPane.add(jButtonPane, cc.xy(2, 3));
		}
		contentPane.add(jContentPane, cc.xy(1, 3));
		pack();
		setLocationRelativeTo(getOwner());
		// JFormDesigner - End of component initialization//GEN-END:initComponents
    }
    
	// JFormDesigner - Variables declaration - DO NOT MODIFY//GEN-BEGIN:variables
	// Generated using JFormDesigner non-commercial license
	private GenericGradientPane jHeaderPane;
	private JLabel jHTitleLbl;
	private JLabel jHTitleIcon;
	private JLabel jHTitleDescLbl;
	private JPanel jContentPane;
	private JTabbedPane jPropertyTabs;
	private JScrollPane scrollPane2;
	private JPanel jGenInfoPane;
	private JComponent goodiesFormsSeparator1;
	private JLabel jScenName;
	private JTextField jScenNameVal;
	private JLabel jOwner;
	private JTextField jOwnerValue;
	private JLabel jOwner2;
	private JTextField jOwnerValue2;
	private JLabel jScenDesc;
	private JScrollPane scrollPane1;
	private JTextArea jScenDescVal;
	private JComponent jDatesTitle;
	private JLabel jResImage;
	private JPanel jButtonPane;
	private JButton jOkBtn;
	private JButton jCancelBtn;
	// JFormDesigner - End of variables declaration//GEN-END:variables
}
