/*
 * Created by JFormDesigner on Wed Feb 13 13:44:37 CET 2008
 */

package pl.psnc.expres.wfm.gui.perspective.ccf;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;

import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingConstants;
import javax.swing.border.LineBorder;
import javax.swing.table.DefaultTableModel;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import pl.psnc.expres.model.experiment.VlbiExperiment;
import pl.psnc.expres.model.factory.VlbiExperimentFactory;
import pl.psnc.expres.remote.vex2ccf.model.CCFFrequency;
import pl.psnc.expres.remote.vex2ccf.model.CCFValue;
import pl.psnc.expres.wfm.gui.JAbstractHeaderPane;
import pl.psnc.expres.wfm.gui.model.table.CustomListTableModel;
import pl.psnc.expres.wfm.gui.model.table.CustomMapTableModel;
import pl.psnc.expres.wfm.gui.model.table.FrequencyTableModel;
import pl.psnc.expres.wfm.gui.model.table.info.WfmColumnType;
import pl.psnc.vlab.util.collection.CollectionHelper;
import pl.psnc.vlab.util.gui.frame.JGenericPane;
import pl.psnc.vlab.util.gui.model.info.ColumnInfo;
import pl.psnc.vlab.util.gui.model.info.ModelProperties;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.DefaultComponentFactory;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpec;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Sizes;
import com.jgoodies.looks.Options;
import com.jgoodies.uif_lite.panel.SimpleInternalFrame;

/**
 * {@link CcfEditorView} class - correlator control file editor class
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public class CcfEditorView extends JPanel {

	/** Default serial uid */
	private static final long serialVersionUID = 1L;

	/** Stores instance of field: log */
	private final Log log = LogFactory.getLog(CcfEditorView.class);

	/** Stores instance of field: ccfValue */
	private CCFValue ccfValue;

	/**
	 * Creates a new instance of CCF Editor
	 */
	public CcfEditorView() {
		initComponents();
		initForm();
	}

	/**
	 * Initialise form components
	 */
	@SuppressWarnings("deprecation")
	private void initComponents() {
		// JFormDesigner - Component initialization - DO NOT MODIFY
		// //GEN-BEGIN:initComponents
		// Generated using JFormDesigner non-commercial license
		ResourceBundle bundle = ResourceBundle.getBundle("bundle.gui");
		DefaultComponentFactory compFactory = DefaultComponentFactory.getInstance();
		jHeaderIFrame = new SimpleInternalFrame();
		jHeaderPane = new JAbstractHeaderPane();
		jHTitleLbl = compFactory.createTitle(bundle
				.getString("ccf.editor.view.jHTitleLbl.textWithMnemonic"));
		jHTitleIcon = new JLabel();
		jHTitleDescLbl = compFactory.createLabel(bundle
				.getString("ccf.editor.view.jHTitleDescLbl.textWithMnemonic"));
		jContentScrollPane = new JScrollPane();
		jCcflFrame = new SimpleInternalFrame();
		jContentTabbedPane = new JTabbedPane();
		jBorderPane1 = new JPanel();
		jExperimentDetailsPane = new JPanel();
		separator2 = compFactory.createSeparator(bundle
				.getString("ccf.editor.view.separator2.text"));
		jExperimentNameLbl2 = compFactory.createTitle(bundle
				.getString("ccf.editor.view.jExperimentNameLbl2.textWithMnemonic"));
		jExperimentNameTFld = new JTextField();
		jExperimentStartLbl2 = compFactory.createTitle(bundle
				.getString("ccf.editor.view.jExperimentStartLbl2.textWithMnemonic"));
		jExperimentStartTFld = new JTextField();
		jExperimentEndLbl2 = compFactory.createTitle(bundle
				.getString("ccf.editor.view.jExperimentEndLbl2.textWithMnemonic"));
		jExperimentStopTFld = new JTextField();
		separator7 = compFactory.createSeparator(bundle
				.getString("ccf.editor.view.separator7.text"));
		jNumberOfChannelsLbl2 = compFactory.createTitle(bundle
				.getString("ccf.editor.view.jNumberOfChannelsLbl2.textWithMnemonic"));
		jNumberOfChannelsSpinner = new JSpinner();
		jIntegrationTimeLbl2 = compFactory.createTitle(bundle
				.getString("ccf.editor.view.jIntegrationTimeLbl2.textWithMnemonic"));
		jIntegrationTimeSpinner = new JSpinner();
		jComputeCrossPolLbl3 = compFactory.createTitle(bundle
				.getString("ccf.editor.view.jComputeCrossPolLbl3.textWithMnemonic"));
		jComputeCrossPolarizeCBox = new JCheckBox();
		separator8 = compFactory.createSeparator(bundle
				.getString("ccf.editor.view.separator8.text"));
		jComputeCrossPolLbl4 = compFactory.createTitle(bundle
				.getString("ccf.editor.view.jComputeCrossPolLbl4.textWithMnemonic"));
		jDebugModeCombo = new JComboBox();
		jBorderPane2 = new JPanel();
		jDataSourcesDetailslPane = new JPanel();
		separator33 = compFactory.createSeparator(bundle
				.getString("ccf.editor.view.separator33.text"));
		scrollPane4 = new JScrollPane();
		jDataSourcesTable = new JTable();
		jDelayDirectoryLbl = compFactory.createTitle(bundle
				.getString("ccf.editor.view.jDelayDirectoryLbl.textWithMnemonic"));
		jDelayDirectoryTFld = new JTextField();
		jOutputFileLbl = compFactory.createTitle(bundle
				.getString("ccf.editor.view.jOutputFileLbl.textWithMnemonic"));
		jOutputFileTFld = new JTextField();
		jBorderPane3 = new JPanel();
		jStationDetailPane = new JPanel();
		separator3 = compFactory.createSeparator(bundle
				.getString("ccf.editor.view.separator3.text"));
		jStationReferenceStationLbl = compFactory.createTitle(bundle
				.getString("ccf.editor.view.jStationReferenceStationLbl.textWithMnemonic"));
		jReferenceStationTFld = new JTextField();
		separator4 = compFactory.createSeparator(bundle
				.getString("ccf.editor.view.separator4.text"));
		scrollPane3 = new JScrollPane();
		jStationTable = new JTable();
		separator10 = compFactory.createSeparator(bundle
				.getString("ccf.editor.view.separator10.text"));
		scrollPane2 = new JScrollPane();
		jFrequencyTable = new JTable();
		jBorderPane4 = new JPanel();
		jStationDetailPane2 = new JPanel();
		separator11 = compFactory.createSeparator(bundle
				.getString("ccf.editor.view.separator11.text"));
		scrollPane6 = new JScrollPane();
		jSitePositionTable = new JTable();
		JButtonPane = new JGenericPane();
		jSaveBtn = new JButton();
		jCcfToolBar = new JToolBar();
		jSourceBtn = new JButton();
		jJsonBtn = new JButton();
		CellConstraints cc = new CellConstraints();

		// ======== this ========
		setPreferredSize(new Dimension(250, 500));
		setName("this");

		// ======== jHeaderIFrame ========
		{
			jHeaderIFrame.setTitle(bundle.getString("ccf.editor.view.jHeaderIFrame.title"));
			jHeaderIFrame.setName("jHeaderIFrame");
			Container jHeaderIFrameContentPane = jHeaderIFrame.getContentPane();

			// ======== jHeaderPane ========
			{
				jHeaderPane.setBorder(LineBorder.createBlackLineBorder());
				jHeaderPane.setPreferredSize(new Dimension(400, 100));
				jHeaderPane.setName("jHeaderPane");

				// ---- jHTitleLbl ----
				jHTitleLbl.setName("jHTitleLbl");

				// ---- jHTitleIcon ----
				jHTitleIcon.setIcon(new ImageIcon(getClass().getResource(
						"/images/graph/radio_telescope.png")));
				jHTitleIcon.setName("jHTitleIcon");

				// ---- jHTitleDescLbl ----
				jHTitleDescLbl.setName("jHTitleDescLbl");

				PanelBuilder jHeaderPaneBuilder = new PanelBuilder(new FormLayout(new ColumnSpec[] {
						new ColumnSpec(Sizes.DLUX8), FormFactory.UNRELATED_GAP_COLSPEC,
						new ColumnSpec(ColumnSpec.FILL, Sizes.DEFAULT, FormSpec.DEFAULT_GROW),
						FormFactory.DEFAULT_COLSPEC, new ColumnSpec(Sizes.DLUX8) }, new RowSpec[] {
						new RowSpec(RowSpec.FILL, Sizes.DEFAULT, FormSpec.DEFAULT_GROW),
						FormFactory.DEFAULT_ROWSPEC,
						new RowSpec(RowSpec.FILL, Sizes.DLUY8, FormSpec.NO_GROW),
						new RowSpec(RowSpec.FILL, Sizes.DEFAULT, FormSpec.NO_GROW),
						new RowSpec(RowSpec.FILL, Sizes.DEFAULT, FormSpec.DEFAULT_GROW) }),
						jHeaderPane);
				((FormLayout) jHeaderPane.getLayout()).setColumnGroups(new int[][] { { 1, 5 } });

				jHeaderPaneBuilder.add(jHTitleLbl, cc.xywh(2, 2, 2, 1));
				jHeaderPaneBuilder.add(jHTitleIcon, cc.xywh(4, 2, 1, 3));
				jHeaderPaneBuilder.add(jHTitleDescLbl, cc.xy(3, 4));
			}

			PanelBuilder jHeaderIFrameContentPaneBuilder = new PanelBuilder(new FormLayout(
					"default:grow", "fill:default"));
			jHeaderIFrameContentPane.setLayout(new BorderLayout());
			jHeaderIFrameContentPane.add(jHeaderIFrameContentPaneBuilder.getPanel(),
					BorderLayout.CENTER);

			jHeaderIFrameContentPaneBuilder.add(jHeaderPane, cc.xy(1, 1));
		}

		// ======== jContentScrollPane ========
		{
			jContentScrollPane.setPreferredSize(new Dimension(500, 400));
			jContentScrollPane.setBorder(Borders.createEmptyBorder("0dlu, 0dlu, 0dlu, 0dlu"));
			jContentScrollPane.setName("jContentScrollPane");

			// ======== jCcflFrame ========
			{
				jCcflFrame.setTitle(bundle.getString("ccf.editor.view.jCcflFrame.title"));
				jCcflFrame.setToolBar(jCcfToolBar);
				jCcflFrame.setOpaque(false);
				jCcflFrame.setBackground(Color.white);
				jCcflFrame.setMinimumSize(new Dimension(100, 100));
				jCcflFrame.setPreferredSize(new Dimension(500, 400));
				jCcflFrame.setFrameIcon(new ImageIcon(getClass().getResource(
						"/images/eclipse/json/java_model_obj.png")));
				jCcflFrame.setName("jCcflFrame");
				Container jCcflFrameContentPane = jCcflFrame.getContentPane();

				// ======== jContentTabbedPane ========
				{
					jContentTabbedPane.setBackground(Color.white);
					jContentTabbedPane.setBorder(Borders
							.createEmptyBorder("0dlu, 0dlu, 0dlu, 0dlu"));
					jContentTabbedPane.setOpaque(true);
					jContentTabbedPane.setName("jContentTabbedPane");

					// ======== jBorderPane1 ========
					{
						jBorderPane1.setName("jBorderPane1");

						// ======== jExperimentDetailsPane ========
						{
							jExperimentDetailsPane.setBorder(LineBorder.createBlackLineBorder());
							jExperimentDetailsPane.setBackground(Color.white);
							jExperimentDetailsPane.setName("jExperimentDetailsPane");

							// ---- separator2 ----
							separator2.setName("separator2");

							// ---- jExperimentNameLbl2 ----
							jExperimentNameLbl2.setName("jExperimentNameLbl2");

							// ---- jExperimentNameTFld ----
							jExperimentNameTFld.setBackground(Color.white);
							jExperimentNameTFld.setEditable(false);
							jExperimentNameTFld.setHorizontalAlignment(SwingConstants.LEFT);
							jExperimentNameTFld.setName("jExperimentNameTFld");

							// ---- jExperimentStartLbl2 ----
							jExperimentStartLbl2.setName("jExperimentStartLbl2");

							// ---- jExperimentStartTFld ----
							jExperimentStartTFld.setBackground(Color.white);
							jExperimentStartTFld.setEditable(false);
							jExperimentStartTFld.setName("jExperimentStartTFld");

							// ---- jExperimentEndLbl2 ----
							jExperimentEndLbl2.setName("jExperimentEndLbl2");

							// ---- jExperimentStopTFld ----
							jExperimentStopTFld.setBackground(Color.white);
							jExperimentStopTFld.setEditable(false);
							jExperimentStopTFld.setName("jExperimentStopTFld");

							// ---- separator7 ----
							separator7.setName("separator7");

							// ---- jNumberOfChannelsLbl2 ----
							jNumberOfChannelsLbl2.setName("jNumberOfChannelsLbl2");

							// ---- jNumberOfChannelsSpinner ----
							jNumberOfChannelsSpinner.setModel(new SpinnerNumberModel(32, 32, 4096,
									16));
							jNumberOfChannelsSpinner.setName("jNumberOfChannelsSpinner");

							// ---- jIntegrationTimeLbl2 ----
							jIntegrationTimeLbl2.setName("jIntegrationTimeLbl2");

							// ---- jIntegrationTimeSpinner ----
							jIntegrationTimeSpinner.setModel(new SpinnerNumberModel(0.25, 0.25,
									4.0, 0.25));
							jIntegrationTimeSpinner.setName("jIntegrationTimeSpinner");

							// ---- jComputeCrossPolLbl3 ----
							jComputeCrossPolLbl3.setName("jComputeCrossPolLbl3");

							// ---- jComputeCrossPolarizeCBox ----
							jComputeCrossPolarizeCBox.setOpaque(false);
							jComputeCrossPolarizeCBox.setPreferredSize(new Dimension(14, 22));
							jComputeCrossPolarizeCBox.setMaximumSize(new Dimension(14, 22));
							jComputeCrossPolarizeCBox.setName("jComputeCrossPolarizeCBox");

							// ---- separator8 ----
							separator8.setName("separator8");

							// ---- jComputeCrossPolLbl4 ----
							jComputeCrossPolLbl4.setName("jComputeCrossPolLbl4");

							// ---- jDebugModeCombo ----
							jDebugModeCombo.setModel(new DefaultComboBoxModel(new String[] {
									"No output", "Only errors", "Debug" }));
							jDebugModeCombo.setName("jDebugModeCombo");

							PanelBuilder jExperimentDetailsPaneBuilder = new PanelBuilder(
									new FormLayout(new ColumnSpec[] {
											FormFactory.UNRELATED_GAP_COLSPEC,
											FormFactory.UNRELATED_GAP_COLSPEC,
											new ColumnSpec("max(default;100dlu)"),
											FormFactory.RELATED_GAP_COLSPEC,
											new ColumnSpec(ColumnSpec.FILL, Sizes.DEFAULT,
													FormSpec.DEFAULT_GROW),
											FormFactory.RELATED_GAP_COLSPEC,
											FormFactory.UNRELATED_GAP_COLSPEC },
											new RowSpec[] {
													new RowSpec(RowSpec.FILL, Sizes.DLUY8,
															FormSpec.NO_GROW),
													FormFactory.DEFAULT_ROWSPEC,
													FormFactory.LINE_GAP_ROWSPEC,
													FormFactory.DEFAULT_ROWSPEC,
													FormFactory.RELATED_GAP_ROWSPEC,
													FormFactory.DEFAULT_ROWSPEC,
													FormFactory.RELATED_GAP_ROWSPEC,
													FormFactory.DEFAULT_ROWSPEC,
													FormFactory.PARAGRAPH_GAP_ROWSPEC,
													FormFactory.DEFAULT_ROWSPEC,
													FormFactory.LINE_GAP_ROWSPEC,
													FormFactory.DEFAULT_ROWSPEC,
													FormFactory.RELATED_GAP_ROWSPEC,
													FormFactory.DEFAULT_ROWSPEC,
													FormFactory.RELATED_GAP_ROWSPEC,
													FormFactory.DEFAULT_ROWSPEC,
													FormFactory.PARAGRAPH_GAP_ROWSPEC,
													FormFactory.DEFAULT_ROWSPEC,
													FormFactory.LINE_GAP_ROWSPEC,
													FormFactory.DEFAULT_ROWSPEC,
													new RowSpec(RowSpec.FILL, Sizes.DLUY8,
															FormSpec.NO_GROW) }),
									jExperimentDetailsPane);

							jExperimentDetailsPaneBuilder.add(separator2, cc.xywh(2, 2, 5, 1));
							jExperimentDetailsPaneBuilder.add(jExperimentNameLbl2, cc.xy(3, 4));
							jExperimentDetailsPaneBuilder.add(jExperimentNameTFld, cc.xy(5, 4));
							jExperimentDetailsPaneBuilder.add(jExperimentStartLbl2, cc.xy(3, 6));
							jExperimentDetailsPaneBuilder.add(jExperimentStartTFld, cc.xy(5, 6));
							jExperimentDetailsPaneBuilder.add(jExperimentEndLbl2, cc.xy(3, 8));
							jExperimentDetailsPaneBuilder.add(jExperimentStopTFld, cc.xy(5, 8));
							jExperimentDetailsPaneBuilder.add(separator7, cc.xywh(2, 10, 5, 1));
							jExperimentDetailsPaneBuilder.add(jNumberOfChannelsLbl2, cc.xy(3, 12));
							jExperimentDetailsPaneBuilder.add(jNumberOfChannelsSpinner, cc
									.xy(5, 12));
							jExperimentDetailsPaneBuilder.add(jIntegrationTimeLbl2, cc.xy(3, 14));
							jExperimentDetailsPaneBuilder
									.add(jIntegrationTimeSpinner, cc.xy(5, 14));
							jExperimentDetailsPaneBuilder.add(jComputeCrossPolLbl3, cc.xy(3, 16));
							jExperimentDetailsPaneBuilder.add(jComputeCrossPolarizeCBox, cc.xy(5,
									16));
							jExperimentDetailsPaneBuilder.add(separator8, cc.xywh(2, 18, 5, 1));
							jExperimentDetailsPaneBuilder.add(jComputeCrossPolLbl4, cc.xy(3, 20));
							jExperimentDetailsPaneBuilder.add(jDebugModeCombo, cc.xy(5, 20));
						}

						PanelBuilder jBorderPane1Builder = new PanelBuilder(
								new FormLayout(
										new ColumnSpec[] {
												new ColumnSpec(Sizes.DLUX8),
												new ColumnSpec(ColumnSpec.FILL, Sizes.DEFAULT,
														FormSpec.DEFAULT_GROW),
												new ColumnSpec(Sizes.DLUX8) }, new RowSpec[] {
												new RowSpec(RowSpec.FILL, Sizes.DLUY8,
														FormSpec.NO_GROW),
												new RowSpec(RowSpec.FILL, Sizes.DEFAULT,
														FormSpec.DEFAULT_GROW),
												new RowSpec(RowSpec.FILL, Sizes.DLUY8,
														FormSpec.NO_GROW) }), jBorderPane1);

						jBorderPane1Builder.add(jExperimentDetailsPane, cc.xy(2, 2));
					}
					jContentTabbedPane.addTab("Experiment Details", jBorderPane1);

					// ======== jBorderPane2 ========
					{
						jBorderPane2.setName("jBorderPane2");

						// ======== jDataSourcesDetailslPane ========
						{
							jDataSourcesDetailslPane.setBackground(Color.white);
							jDataSourcesDetailslPane.setBorder(LineBorder.createBlackLineBorder());
							jDataSourcesDetailslPane.setName("jDataSourcesDetailslPane");

							// ---- separator33 ----
							separator33.setName("separator33");

							// ======== scrollPane4 ========
							{
								scrollPane4.setPreferredSize(new Dimension(200, 200));
								scrollPane4.setBackground(Color.white);
								scrollPane4.setName("scrollPane4");

								// ---- jDataSourcesTable ----
								jDataSourcesTable.setModel(new DefaultTableModel(new Object[][] {
										{ null, null }, { null, null }, { null, null },
										{ null, null }, { null, null }, { null, null },
										{ null, null }, { null, null }, { null, null }, },
										new String[] { "Station Name", "Data source" }));
								jDataSourcesTable.setPreferredScrollableViewportSize(new Dimension(
										250, 200));
								jDataSourcesTable.setFillsViewportHeight(true);
								jDataSourcesTable.setName("jDataSourcesTable");
								scrollPane4.setViewportView(jDataSourcesTable);
							}

							// ---- jDelayDirectoryLbl ----
							jDelayDirectoryLbl.setName("jDelayDirectoryLbl");

							// ---- jDelayDirectoryTFld ----
							jDelayDirectoryTFld.setName("jDelayDirectoryTFld");

							// ---- jOutputFileLbl ----
							jOutputFileLbl.setName("jOutputFileLbl");

							// ---- jOutputFileTFld ----
							jOutputFileTFld.setName("jOutputFileTFld");

							PanelBuilder jDataSourcesDetailslPaneBuilder = new PanelBuilder(
									new FormLayout(new ColumnSpec[] {
											FormFactory.UNRELATED_GAP_COLSPEC,
											FormFactory.UNRELATED_GAP_COLSPEC,
											new ColumnSpec("max(default;80dlu)"),
											FormFactory.UNRELATED_GAP_COLSPEC,
											new ColumnSpec(ColumnSpec.FILL, Sizes.DEFAULT,
													FormSpec.DEFAULT_GROW),
											FormFactory.RELATED_GAP_COLSPEC,
											FormFactory.UNRELATED_GAP_COLSPEC },
											new RowSpec[] {
													new RowSpec(RowSpec.FILL, Sizes.DLUY8,
															FormSpec.NO_GROW),
													FormFactory.DEFAULT_ROWSPEC,
													FormFactory.LINE_GAP_ROWSPEC,
													FormFactory.DEFAULT_ROWSPEC,
													FormFactory.PARAGRAPH_GAP_ROWSPEC,
													FormFactory.DEFAULT_ROWSPEC,
													FormFactory.LINE_GAP_ROWSPEC,
													FormFactory.DEFAULT_ROWSPEC,
													new RowSpec(RowSpec.FILL, Sizes.DLUY8,
															FormSpec.NO_GROW) }),
									jDataSourcesDetailslPane);

							jDataSourcesDetailslPaneBuilder.add(separator33, cc.xywh(2, 2, 5, 1));
							jDataSourcesDetailslPaneBuilder.add(scrollPane4, cc.xywh(3, 4, 3, 1));
							jDataSourcesDetailslPaneBuilder.add(jDelayDirectoryLbl, cc.xy(3, 6));
							jDataSourcesDetailslPaneBuilder.add(jDelayDirectoryTFld, cc.xy(5, 6));
							jDataSourcesDetailslPaneBuilder.add(jOutputFileLbl, cc.xy(3, 8));
							jDataSourcesDetailslPaneBuilder.add(jOutputFileTFld, cc.xy(5, 8));
						}

						PanelBuilder jBorderPane2Builder = new PanelBuilder(
								new FormLayout(
										new ColumnSpec[] {
												new ColumnSpec(Sizes.DLUX8),
												new ColumnSpec(ColumnSpec.FILL, Sizes.DEFAULT,
														FormSpec.DEFAULT_GROW),
												new ColumnSpec(Sizes.DLUX8) }, new RowSpec[] {
												new RowSpec(RowSpec.FILL, Sizes.DLUY8,
														FormSpec.NO_GROW),
												new RowSpec(RowSpec.FILL, Sizes.DEFAULT,
														FormSpec.DEFAULT_GROW),
												new RowSpec(RowSpec.FILL, Sizes.DLUY8,
														FormSpec.NO_GROW) }), jBorderPane2);

						jBorderPane2Builder.add(jDataSourcesDetailslPane, cc.xy(2, 2));
					}
					jContentTabbedPane.addTab("Data Sources", jBorderPane2);

					// ======== jBorderPane3 ========
					{
						jBorderPane3.setName("jBorderPane3");

						// ======== jStationDetailPane ========
						{
							jStationDetailPane.setBorder(LineBorder.createBlackLineBorder());
							jStationDetailPane.setBackground(Color.white);
							jStationDetailPane.setName("jStationDetailPane");

							// ---- separator3 ----
							separator3.setName("separator3");

							// ---- jStationReferenceStationLbl ----
							jStationReferenceStationLbl.setName("jStationReferenceStationLbl");

							// ---- jReferenceStationTFld ----
							jReferenceStationTFld.setEditable(false);
							jReferenceStationTFld.setBackground(Color.white);
							jReferenceStationTFld.setName("jReferenceStationTFld");

							// ---- separator4 ----
							separator4.setName("separator4");

							// ======== scrollPane3 ========
							{
								scrollPane3.setPreferredSize(new Dimension(200, 200));
								scrollPane3.setBackground(Color.white);
								scrollPane3.setName("scrollPane3");

								// ---- jStationTable ----
								jStationTable.setModel(new DefaultTableModel(new Object[][] {
										{ null }, { null }, { null }, { null }, { null }, { null },
										{ null }, { null }, { null }, { null }, { null }, { null },
										{ null }, { null }, }, new String[] { "Statiion Name" }));
								jStationTable.setFillsViewportHeight(true);
								jStationTable.setName("jStationTable");
								scrollPane3.setViewportView(jStationTable);
							}

							// ---- separator10 ----
							separator10.setName("separator10");

							// ======== scrollPane2 ========
							{
								scrollPane2.setName("scrollPane2");

								// ---- jFrequencyTable ----
								jFrequencyTable.setModel(new DefaultTableModel(new Object[][] {
										{ null, null, null, null }, { null, null, null, null },
										{ null, null, null, null }, { null, null, null, null },
										{ null, null, null, null }, { null, null, null, null },
										{ null, null, null, null }, { null, null, null, null },
										{ null, null, null, null }, }, new String[] { "Frequency",
										"Bandwidth", "Sideband", "Polarisation" }));
								jFrequencyTable.setFillsViewportHeight(true);
								jFrequencyTable.setName("jFrequencyTable");
								scrollPane2.setViewportView(jFrequencyTable);
							}

							PanelBuilder jStationDetailPaneBuilder = new PanelBuilder(
									new FormLayout(new ColumnSpec[] {
											FormFactory.UNRELATED_GAP_COLSPEC,
											FormFactory.UNRELATED_GAP_COLSPEC,
											new ColumnSpec("max(default;80dlu)"),
											FormFactory.UNRELATED_GAP_COLSPEC,
											new ColumnSpec(ColumnSpec.FILL, Sizes.DEFAULT,
													FormSpec.DEFAULT_GROW),
											FormFactory.RELATED_GAP_COLSPEC,
											FormFactory.UNRELATED_GAP_COLSPEC },
											new RowSpec[] {
													new RowSpec(RowSpec.FILL, Sizes.DLUY8,
															FormSpec.NO_GROW),
													FormFactory.DEFAULT_ROWSPEC,
													FormFactory.LINE_GAP_ROWSPEC,
													FormFactory.DEFAULT_ROWSPEC,
													FormFactory.PARAGRAPH_GAP_ROWSPEC,
													FormFactory.DEFAULT_ROWSPEC,
													FormFactory.LINE_GAP_ROWSPEC,
													new RowSpec(RowSpec.FILL, Sizes.DEFAULT,
															FormSpec.DEFAULT_GROW),
													FormFactory.PARAGRAPH_GAP_ROWSPEC,
													FormFactory.DEFAULT_ROWSPEC,
													FormFactory.LINE_GAP_ROWSPEC,
													new RowSpec(RowSpec.FILL, Sizes.DEFAULT,
															FormSpec.DEFAULT_GROW),
													new RowSpec(RowSpec.FILL, Sizes.DLUY8,
															FormSpec.NO_GROW) }),
									jStationDetailPane);

							jStationDetailPaneBuilder.add(separator3, cc.xywh(2, 2, 5, 1));
							jStationDetailPaneBuilder.add(jStationReferenceStationLbl, cc.xy(3, 4));
							jStationDetailPaneBuilder.add(jReferenceStationTFld, cc.xy(5, 4));
							jStationDetailPaneBuilder.add(separator4, cc.xywh(2, 6, 5, 1));
							jStationDetailPaneBuilder.add(scrollPane3, cc.xywh(3, 8, 3, 1));
							jStationDetailPaneBuilder.add(separator10, cc.xywh(2, 10, 5, 1));
							jStationDetailPaneBuilder.add(scrollPane2, cc.xywh(3, 12, 3, 1));
						}

						PanelBuilder jBorderPane3Builder = new PanelBuilder(
								new FormLayout(
										new ColumnSpec[] {
												new ColumnSpec(Sizes.DLUX8),
												new ColumnSpec(ColumnSpec.FILL, Sizes.DEFAULT,
														FormSpec.DEFAULT_GROW),
												new ColumnSpec(Sizes.DLUX8) }, new RowSpec[] {
												new RowSpec(RowSpec.FILL, Sizes.DLUY8,
														FormSpec.NO_GROW),
												new RowSpec(RowSpec.FILL, Sizes.DEFAULT,
														FormSpec.DEFAULT_GROW),
												new RowSpec(RowSpec.FILL, Sizes.DLUY8,
														FormSpec.NO_GROW) }), jBorderPane3);

						jBorderPane3Builder.add(jStationDetailPane, cc.xy(2, 2));
					}
					jContentTabbedPane.addTab("Station Details", jBorderPane3);

					// ======== jBorderPane4 ========
					{
						jBorderPane4.setName("jBorderPane4");

						// ======== jStationDetailPane2 ========
						{
							jStationDetailPane2.setBorder(LineBorder.createBlackLineBorder());
							jStationDetailPane2.setBackground(Color.white);
							jStationDetailPane2.setName("jStationDetailPane2");

							// ---- separator11 ----
							separator11.setName("separator11");

							// ======== scrollPane6 ========
							{
								scrollPane6.setName("scrollPane6");

								// ---- jSitePositionTable ----
								jSitePositionTable.setModel(new DefaultTableModel(new Object[][] {
										{ null, null, null, null }, { null, null, null, null },
										{ null, null, null, null }, { null, null, null, null },
										{ null, null, null, null }, { null, null, null, null },
										{ null, null, null, null }, { null, null, null, null },
										{ null, null, null, null }, }, new String[] { "Frequency",
										"Bandwidth", "Sideband", "Polarisation" }));
								jSitePositionTable.setFillsViewportHeight(true);
								jSitePositionTable.setName("jSitePositionTable");
								scrollPane6.setViewportView(jSitePositionTable);
							}

							PanelBuilder jStationDetailPane2Builder = new PanelBuilder(
									new FormLayout(new ColumnSpec[] {
											FormFactory.UNRELATED_GAP_COLSPEC,
											FormFactory.UNRELATED_GAP_COLSPEC,
											new ColumnSpec("max(default;80dlu)"),
											FormFactory.UNRELATED_GAP_COLSPEC,
											new ColumnSpec(ColumnSpec.FILL, Sizes.DEFAULT,
													FormSpec.DEFAULT_GROW),
											FormFactory.RELATED_GAP_COLSPEC,
											FormFactory.UNRELATED_GAP_COLSPEC },
											new RowSpec[] {
													new RowSpec(RowSpec.FILL, Sizes.DLUY8,
															FormSpec.NO_GROW),
													FormFactory.DEFAULT_ROWSPEC,
													FormFactory.LINE_GAP_ROWSPEC,
													new RowSpec(RowSpec.FILL, Sizes.DEFAULT,
															FormSpec.DEFAULT_GROW),
													new RowSpec(RowSpec.FILL, Sizes.DLUY8,
															FormSpec.NO_GROW) }),
									jStationDetailPane2);

							jStationDetailPane2Builder.add(separator11, cc.xywh(2, 2, 5, 1));
							jStationDetailPane2Builder.add(scrollPane6, cc.xywh(3, 4, 3, 1));
						}

						PanelBuilder jBorderPane4Builder = new PanelBuilder(
								new FormLayout(
										new ColumnSpec[] {
												new ColumnSpec(Sizes.DLUX8),
												new ColumnSpec(ColumnSpec.FILL, Sizes.DEFAULT,
														FormSpec.DEFAULT_GROW),
												new ColumnSpec(Sizes.DLUX8) }, new RowSpec[] {
												new RowSpec(RowSpec.FILL, Sizes.DLUY8,
														FormSpec.NO_GROW),
												new RowSpec(RowSpec.FILL, Sizes.DEFAULT,
														FormSpec.DEFAULT_GROW),
												new RowSpec(RowSpec.FILL, Sizes.DLUY8,
														FormSpec.NO_GROW) }), jBorderPane4);

						jBorderPane4Builder.add(jStationDetailPane2, cc.xy(2, 2));
					}
					jContentTabbedPane.addTab("Site Postions", jBorderPane4);

				}

				// ======== JButtonPane ========
				{
					JButtonPane.setOpaque(false);
					JButtonPane.setName("JButtonPane");

					// ---- jSaveBtn ----
					jSaveBtn.setText(bundle.getString("ccf.editor.view.jSaveBtn.text"));
					jSaveBtn.setIcon(new ImageIcon(getClass().getResource(
							"/images/eclipse/menu/save_single.gif")));
					jSaveBtn.setMnemonic(bundle.getString("ccf.editor.view.jSaveBtn.mnemonic")
							.charAt(0));
					jSaveBtn.setName("jSaveBtn");

					PanelBuilder JButtonPaneBuilder = new PanelBuilder(new FormLayout(
							new ColumnSpec[] { FormFactory.BUTTON_COLSPEC,
									new ColumnSpec(Sizes.DLUX8) }, RowSpec
									.decodeSpecs("fill:default:grow")), JButtonPane);

					JButtonPaneBuilder.add(jSaveBtn, cc.xy(1, 1));
				}

				PanelBuilder jCcflFrameContentPaneBuilder = new PanelBuilder(new FormLayout(
						ColumnSpec.decodeSpecs("default:grow"), new RowSpec[] {
								new RowSpec(RowSpec.FILL, Sizes.DEFAULT, FormSpec.DEFAULT_GROW),
								FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC,
								FormFactory.RELATED_GAP_ROWSPEC }));
				jCcflFrameContentPane.setLayout(new BorderLayout());
				jCcflFrameContentPane.add(jCcflFrameContentPaneBuilder.getPanel(),
						BorderLayout.CENTER);

				jCcflFrameContentPaneBuilder.add(jContentTabbedPane, cc.xy(1, 1));
				jCcflFrameContentPaneBuilder.add(JButtonPane, cc.xywh(1, 3, 1, 1,
						CellConstraints.RIGHT, CellConstraints.DEFAULT));
			}
			jContentScrollPane.setViewportView(jCcflFrame);
		}

		PanelBuilder builder = new PanelBuilder(new FormLayout(ColumnSpec
				.decodeSpecs("default:grow"), new RowSpec[] { FormFactory.DEFAULT_ROWSPEC,
				FormFactory.RELATED_GAP_ROWSPEC,
				new RowSpec(RowSpec.FILL, Sizes.DEFAULT, FormSpec.DEFAULT_GROW) }), this);

		builder.add(jHeaderIFrame, cc.xy(1, 1));
		builder.add(jContentScrollPane, cc.xy(1, 3));

		// ======== jCcfToolBar ========
		{
			jCcfToolBar.setName("jCcfToolBar");

			// ---- jSourceBtn ----
			jSourceBtn.setIcon(new ImageIcon(getClass().getResource(
					"/images/eclipse/menu/segment_edit.gif")));
			jSourceBtn.setToolTipText(bundle.getString("ccf.editor.view.jSourceBtn.toolTipText"));
			jSourceBtn.setBorderPainted(false);
			jSourceBtn.setRolloverEnabled(true);
			jSourceBtn.setEnabled(false);
			jSourceBtn.setName("jSourceBtn");
			jCcfToolBar.add(jSourceBtn);

			// ---- jJsonBtn ----
			jJsonBtn.setPreferredSize(new Dimension(28, 28));
			jJsonBtn.setMinimumSize(new Dimension(28, 28));
			jJsonBtn.setMaximumSize(new Dimension(28, 28));
			jJsonBtn.setIcon(new ImageIcon(getClass().getResource(
					"/images/eclipse/json/java_model_obj.png")));
			jJsonBtn.setToolTipText("<html>Switch to <b>Designer View</b></html>");
			jJsonBtn.setBorderPainted(false);
			jJsonBtn.setEnabled(false);
			jJsonBtn.setName("jJsonBtn");
			jCcfToolBar.add(jJsonBtn);
		}
		// //GEN-END:initComponents
	}

	// JFormDesigner - Variables declaration - DO NOT MODIFY
	// //GEN-BEGIN:variables
	// Generated using JFormDesigner non-commercial license
	private SimpleInternalFrame jHeaderIFrame;
	private JAbstractHeaderPane jHeaderPane;
	private JLabel jHTitleLbl;
	private JLabel jHTitleIcon;
	private JLabel jHTitleDescLbl;
	private JScrollPane jContentScrollPane;
	private SimpleInternalFrame jCcflFrame;
	private JTabbedPane jContentTabbedPane;
	private JPanel jBorderPane1;
	private JPanel jExperimentDetailsPane;
	private JComponent separator2;
	private JLabel jExperimentNameLbl2;
	private JTextField jExperimentNameTFld;
	private JLabel jExperimentStartLbl2;
	private JTextField jExperimentStartTFld;
	private JLabel jExperimentEndLbl2;
	private JTextField jExperimentStopTFld;
	private JComponent separator7;
	private JLabel jNumberOfChannelsLbl2;
	private JSpinner jNumberOfChannelsSpinner;
	private JLabel jIntegrationTimeLbl2;
	private JSpinner jIntegrationTimeSpinner;
	private JLabel jComputeCrossPolLbl3;
	private JCheckBox jComputeCrossPolarizeCBox;
	private JComponent separator8;
	private JLabel jComputeCrossPolLbl4;
	private JComboBox jDebugModeCombo;
	private JPanel jBorderPane2;
	private JPanel jDataSourcesDetailslPane;
	private JComponent separator33;
	private JScrollPane scrollPane4;
	private JTable jDataSourcesTable;
	private JLabel jDelayDirectoryLbl;
	private JTextField jDelayDirectoryTFld;
	private JLabel jOutputFileLbl;
	private JTextField jOutputFileTFld;
	private JPanel jBorderPane3;
	private JPanel jStationDetailPane;
	private JComponent separator3;
	private JLabel jStationReferenceStationLbl;
	private JTextField jReferenceStationTFld;
	private JComponent separator4;
	private JScrollPane scrollPane3;
	private JTable jStationTable;
	private JComponent separator10;
	private JScrollPane scrollPane2;
	private JTable jFrequencyTable;
	private JPanel jBorderPane4;
	private JPanel jStationDetailPane2;
	private JComponent separator11;
	private JScrollPane scrollPane6;
	private JTable jSitePositionTable;
	private JGenericPane JButtonPane;
	private JButton jSaveBtn;
	private JToolBar jCcfToolBar;
	private JButton jSourceBtn;
	private JButton jJsonBtn;

	// JFormDesigner - End of variables declaration //GEN-END:variables

	// ----------------------------------------------------------------------------------
	// ---- Private Helper Methods

	/**
	 * Initialises form components
	 */
	private void initForm() {
		jContentTabbedPane.putClientProperty(Options.NO_CONTENT_BORDER_KEY, Boolean.TRUE);
		jContentTabbedPane.putClientProperty(Options.EMBEDDED_TABS_KEY, Boolean.TRUE);

		VlbiExperiment exp = VlbiExperimentFactory.getInstance();
		ccfValue = exp != null ? exp.getCcf() : null;
		fillCCF(ccfValue);

		// init tables
		initTables();
	}

	/**
	 * Initialises form tables
	 */
	private void initTables() {
		ModelProperties modelProp = new ModelProperties();
		modelProp.setColumns(new ColumnInfo[] { WfmColumnType.CCF_FREQUENCY,
				WfmColumnType.CCF_BANDWIDTH, WfmColumnType.CCF_SIDEBAND,
				WfmColumnType.CCF_POLARISATION });
		modelProp.setSortOrder(new ColumnInfo[] { WfmColumnType.CCF_FREQUENCY });
		modelProp.setEditable(new boolean[] { false, false, false, false });
		List<CCFFrequency> frequencies = ccfValue != null ? ccfValue.getFrequencies() : null;
		FrequencyTableModel frequencyTableModel = new FrequencyTableModel(frequencies, modelProp);
		jFrequencyTable.setModel(frequencyTableModel);
		jFrequencyTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);

		// data sources table
		modelProp = new ModelProperties();
		modelProp.setColumns(new ColumnInfo[] { WfmColumnType.CCF_STATION,
				WfmColumnType.CCF_DATA_SOURCE });
		modelProp.setSortOrder(new ColumnInfo[] { WfmColumnType.CCF_STATION });
		modelProp.setEditable(new boolean[] { false, false });

		Map<String, List<String>> data_sources = ccfValue.getData_sources();
		String[][] cData = CollectionHelper.convert(data_sources, 1);
		CustomMapTableModel dataSourceModel = new CustomMapTableModel(cData, modelProp);
		jDataSourcesTable.setModel(dataSourceModel);
		jDataSourcesTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);

		// site position
		modelProp = new ModelProperties();
		modelProp.setColumns(new ColumnInfo[] { WfmColumnType.CCF_STATION,
				WfmColumnType.CCF_SITE_POSITION_X, WfmColumnType.CCF_SITE_POSITION_X,
				WfmColumnType.CCF_SITE_POSITION_X });
		modelProp.setSortOrder(new ColumnInfo[] { WfmColumnType.CCF_STATION });
		modelProp.setEditable(new boolean[] { false, false, false, false });

		Map<String, List<String>> site_position = ccfValue.getSite_position();
		cData = CollectionHelper.convert(site_position, 3);
		CustomMapTableModel sitePositionModel = new CustomMapTableModel(cData, modelProp);
		jSitePositionTable.setModel(sitePositionModel);
		jSitePositionTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);

		// station list
		modelProp = new ModelProperties();
		modelProp.setColumns(new ColumnInfo[] { WfmColumnType.CCF_STATION, });
		modelProp.setSortOrder(new ColumnInfo[] { WfmColumnType.CCF_STATION });
		modelProp.setEditable(new boolean[] { false });

		List<String> stations = ccfValue.getStations();
		CustomListTableModel<String> stationsModel = new CustomListTableModel<String>(stations,
				modelProp);
		jStationTable.setModel(stationsModel);
		jStationTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
	}

	/**
	 * Fill form components with data from {@link CCFValue}
	 * 
	 * @param ccValue instance of {@link CCFValue}
	 */
	private void fillCCF(CCFValue ccValue) {
		log.debug("<fillCCF>");
		if (ccValue == null) {
			log.debug("</fillCCF: NULL>");
			return;
		}

		// Tab Experiment Details
		jExperimentNameTFld.setText(ccValue.getExper_name());
		jExperimentStartTFld.setText(ccValue.getStart());
		jExperimentStopTFld.setText(ccValue.getStop());

		jNumberOfChannelsSpinner.setValue(ccValue.getNumber_channels());
		jIntegrationTimeSpinner.setValue(ccValue.getIntegr_time());
		jComputeCrossPolarizeCBox.setSelected(ccValue.isCross_polarize());
		jDebugModeCombo.setSelectedItem(ccValue.getMessage_level());

		// Tab Data Sources

		// TODO data sources
		jDelayDirectoryTFld.setText(ccValue.getDelay_directory());
		jOutputFileTFld.setText(ccValue.getOutput_file());

		// Tab Station Details
		jReferenceStationTFld.setText(ccValue.getReference_station());
		// TODO station list
		// TODO frequencies

		log.debug("</fillCCF>");
	}

}
