package pl.psnc.expres.wfm.gui.perspective;

import java.awt.Container;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;

import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingConstants;

import pl.psnc.expres.wfm.action.factory.WfmActionType;
import pl.psnc.vlab.util.gui.action.factory.ActionFactory;
import pl.psnc.vlab.util.gui.frame.JGenericPane;
import pl.psnc.vlab.util.gui.message.JMessage;
import pl.psnc.vlab.util.swing.gui.GuiTools;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.DefaultComponentFactory;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpec;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Sizes;
import com.jgoodies.uif_lite.panel.SimpleInternalFrame;

/**
 * {@link JWelcomePane} class - Wfm Welcome Pane
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public class JWelcomePane extends JPanel {

	/** Default Serial uid */
	private static final long serialVersionUID = 1L;

	/** Stores instance of Welcome Pane */
	private static JWelcomePane instance;

	/**
	 * Creates a new instance of JWelcomePane
	 */
	public JWelcomePane() {
		initComponents();
	}

	/**
	 * Initialise form components
	 */
	private void initComponents() {
		// JFormDesigner - Component initialization - DO NOT MODIFY
		// //GEN-BEGIN:initComponents
		// Generated using JFormDesigner non-commercial license
		ResourceBundle bundle = ResourceBundle.getBundle("bundle.gui");
		DefaultComponentFactory compFactory = DefaultComponentFactory.getInstance();
		jContent = new SimpleInternalFrame();
		jContentPane = new JGenericPane();
		jWelcomeLbl = compFactory.createLabel(bundle
				.getString("welcome.pane.jWelcomeLbl.textWithMnemonic"));
		jSSALbl = compFactory
				.createLabel(bundle.getString("welcome.pane.jSSALbl.textWithMnemonic"));
		jOptionLbl = compFactory.createLabel(bundle
				.getString("welcome.pane.jOptionLbl.textWithMnemonic"));
		jOpenVexLbl = compFactory.createLabel(bundle
				.getString("welcome.pane.jOpenVexLbl.textWithMnemonic"));
		jRadioImg = new JLabel();
		jOpenLbl = compFactory.createLabel(bundle
				.getString("welcome.pane.jOpenLbl.textWithMnemonic"));
		jOpenSampleLbl = compFactory.createLabel(bundle
				.getString("welcome.pane.jOpenSampleLbl.textWithMnemonic"));
		CellConstraints cc = new CellConstraints();

		// ======== this ========
		setVisible(true);
		setBorder(Borders.createEmptyBorder("0dlu, 0dlu, 0dlu, 0dlu"));
		setName("this");
		setLayout(new FormLayout("max(default;20dlu):grow", "fill:20dlu:grow"));

		// ======== jContent ========
		{
			jContent.setTitle(bundle.getString("welcome.pane.jContent.title"));
			jContent.setFrameIcon(new ImageIcon(getClass().getResource(
					"/images/eclipse/menu/ch_callers.gif")));
			jContent.setName("jContent");
			Container jContentContentPane = jContent.getContentPane();
			jContentContentPane.setLayout(new FormLayout("max(default;20dlu):grow",
					"fill:20dlu:grow"));

			// ======== jContentPane ========
			{
				jContentPane.setName("jContentPane");
				jContentPane.setLayout(new FormLayout(new ColumnSpec[] {
						FormFactory.UNRELATED_GAP_COLSPEC,
						new ColumnSpec("left:max(default;20dlu)"),
						new ColumnSpec("left:max(default;20dlu)"), FormFactory.DEFAULT_COLSPEC,
						new ColumnSpec(ColumnSpec.FILL, Sizes.DEFAULT, FormSpec.DEFAULT_GROW),
						new ColumnSpec(Sizes.dluX(20)) }, new RowSpec[] {
						new RowSpec(Sizes.dluY(20)), FormFactory.DEFAULT_ROWSPEC,
						FormFactory.PARAGRAPH_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC,
						new RowSpec(RowSpec.TOP, Sizes.dluY(20), FormSpec.NO_GROW),
						FormFactory.DEFAULT_ROWSPEC, FormFactory.PARAGRAPH_GAP_ROWSPEC,
						FormFactory.DEFAULT_ROWSPEC, FormFactory.PARAGRAPH_GAP_ROWSPEC,
						FormFactory.DEFAULT_ROWSPEC, FormFactory.PARAGRAPH_GAP_ROWSPEC,
						FormFactory.DEFAULT_ROWSPEC,
						new RowSpec(RowSpec.FILL, Sizes.DEFAULT, FormSpec.DEFAULT_GROW) }));

				// ---- jWelcomeLbl ----
				jWelcomeLbl.setFont(new Font("Tahoma", Font.PLAIN, 12));
				jWelcomeLbl.setName("jWelcomeLbl");
				jContentPane.add(jWelcomeLbl, cc.xywh(2, 2, 4, 1));

				// ---- jSSALbl ----
				jSSALbl.setFont(new Font("SansSerif", Font.BOLD, 16));
				jSSALbl.setName("jSSALbl");
				jContentPane.add(jSSALbl, cc.xywh(3, 4, 3, 1));

				// ---- jOptionLbl ----
				jOptionLbl.setFont(new Font("Tahoma", Font.PLAIN, 12));
				jOptionLbl.setName("jOptionLbl");
				jContentPane.add(jOptionLbl, cc.xywh(2, 6, 5, 1));

				// ---- jOpenVexLbl ----
				jOpenVexLbl.setIcon(new ImageIcon(getClass().getResource(
						"/images/eclipse/menu/arrowGreen.gif")));
				jOpenVexLbl.setIconTextGap(16);
				jOpenVexLbl.setLabelFor(this);
				jOpenVexLbl.setFont(new Font("Tahoma", Font.PLAIN, 12));
				jOpenVexLbl.setName("jOpenVexLbl");
				jOpenVexLbl.addMouseListener(new MouseAdapter() {
					@Override
					public void mouseEntered(MouseEvent e) {
						jOpenVexLblMouseEntered(e);
					}

					@Override
					public void mouseExited(MouseEvent e) {
						JOpenVexLblMouseExited(e);
					}

					@Override
					public void mousePressed(MouseEvent e) {
						jOpenVexLblMousePressed(e);
					}
				});
				jContentPane.add(jOpenVexLbl, cc.xy(4, 8));

				// ---- jRadioImg ----
				jRadioImg.setIcon(new ImageIcon(getClass()
						.getResource("/images/radiotelescope.png")));
				jRadioImg.setHorizontalAlignment(SwingConstants.RIGHT);
				jRadioImg.setName("jRadioImg");
				jContentPane.add(jRadioImg, cc.xywh(5, 1, 1, 13));

				// ---- jOpenLbl ----
				jOpenLbl.setIcon(new ImageIcon(getClass().getResource(
						"/images/eclipse/menu/arrowGreen.gif")));
				jOpenLbl.setIconTextGap(16);
				jOpenLbl.setFont(new Font("Tahoma", Font.PLAIN, 12));
				jOpenLbl.setEnabled(false);
				jOpenLbl.setName("jOpenLbl");
				jOpenLbl.addMouseListener(new MouseAdapter() {
					@Override
					public void mouseEntered(MouseEvent e) {
						jOpenLblMouseEntered(e);
					}

					@Override
					public void mouseExited(MouseEvent e) {
						jOpenLblMouseExited(e);
					}

					@Override
					public void mousePressed(MouseEvent e) {
						jOpenLblMousePressed(e);
					}
				});
				jContentPane.add(jOpenLbl, cc.xy(4, 10));

				// ---- jOpenSampleLbl ----
				jOpenSampleLbl.setIcon(new ImageIcon(getClass().getResource(
						"/images/eclipse/menu/arrowGreen.gif")));
				jOpenSampleLbl.setIconTextGap(16);
				jOpenSampleLbl.setFont(new Font("Tahoma", Font.PLAIN, 12));
				jOpenSampleLbl.setEnabled(false);
				jOpenSampleLbl.setName("jOpenSampleLbl");
				jOpenSampleLbl.addMouseListener(new MouseAdapter() {
					@Override
					public void mouseEntered(MouseEvent e) {
						jOpenSampleLblMouseEntered(e);
					}

					@Override
					public void mouseExited(MouseEvent e) {
						jOpenSampleLblMouseExited(e);
					}

					@Override
					public void mousePressed(MouseEvent e) {
						jOpenSampleLblMousePressed(e);
					}
				});
				jContentPane.add(jOpenSampleLbl, cc.xy(4, 12));
			}
			jContentContentPane.add(jContentPane, cc.xy(1, 1));
		}
		add(jContent, cc.xy(1, 1));
		// //GEN-END:initComponents
	}

	// JFormDesigner - Variables declaration - DO NOT MODIFY
	// //GEN-BEGIN:variables
	// Generated using JFormDesigner non-commercial license
	private SimpleInternalFrame jContent;
	private JGenericPane jContentPane;
	private JLabel jWelcomeLbl;
	private JLabel jSSALbl;
	private JLabel jOptionLbl;
	private JLabel jOpenVexLbl;
	private JLabel jRadioImg;
	private JLabel jOpenLbl;
	private JLabel jOpenSampleLbl;

	// JFormDesigner - End of variables declaration //GEN-END:variables

	/**
	 * Handles action event
	 * 
	 * @param e instance of {@link MouseEvent}
	 */
	private void jOpenVexLblMouseEntered(MouseEvent e) {
		GuiTools.makeHyperLink(jOpenVexLbl);
	}

	/**
	 * Handles action event
	 * 
	 * @param e instance of {@link MouseEvent}
	 */
	private void jOpenVexLblMousePressed(MouseEvent e) {
		try {
			ActionFactory.getAction(WfmActionType.VEX_OPEN).actionPerformed(null);
		} catch (Exception err) {
			JMessage.showErrorMessage(this, err.getLocalizedMessage());
		}
	}

	/**
	 * Handles action event
	 * 
	 * @param e instance of {@link MouseEvent}
	 */
	private void jOpenLblMouseEntered(MouseEvent e) {
		GuiTools.makeHyperLink(jOpenLbl);
	}

	/**
	 * Handles action event
	 * 
	 * @param e instance of {@link MouseEvent}
	 */
	private void jOpenLblMouseExited(MouseEvent e) {
		GuiTools.removeHyperLink(jOpenLbl);
	}

	/**
	 * Handles action event
	 * 
	 * @param e instance of {@link MouseEvent}
	 */
	private void jOpenLblMousePressed(MouseEvent e) {
		try {
			ActionFactory.getAction(WfmActionType.SCENARIO_OPEN).actionPerformed(null);
		} catch (Exception err) {
			JMessage.showErrorMessage(this, err.getLocalizedMessage());
		}
	}

	/**
	 * Handles action event
	 * 
	 * @param e instance of {@link MouseEvent}
	 */
	private void jOpenSampleLblMouseEntered(MouseEvent e) {
		GuiTools.makeHyperLink(jOpenSampleLbl);
	}

	/**
	 * Handles action event
	 * 
	 * @param e instance of {@link MouseEvent}
	 */
	private void jOpenSampleLblMouseExited(MouseEvent e) {
		GuiTools.removeHyperLink(jOpenSampleLbl);
	}

	/**
	 * Handles action event
	 * 
	 * @param e instance of {@link MouseEvent}
	 */
	private void jOpenSampleLblMousePressed(MouseEvent e) {
		// new JScenarioWizard(JMainFrame.getInstance()).show();
	}

	/**
	 * Handles action event
	 * 
	 * @param e instance of {@link MouseEvent}
	 */
	private void JOpenVexLblMouseExited(MouseEvent e) {
		GuiTools.removeHyperLink(jOpenVexLbl);
	}

	// ----------------------------------------------------------------------------------------
	// ----Static Helper Methods

	/**
	 * Get instance of JWelcome Pane {@link JWelcomePane}
	 * 
	 * @return new instance of JWelcome Pane
	 */
	public static JWelcomePane getInstance() {
		if (instance == null) {
			instance = new JWelcomePane();
		}
		return instance;
	}
}
