/**
 * 
 */
package pl.psnc.expres.wfm.gui.model.table.info;

import java.util.Comparator;

import pl.psnc.vlab.util.gui.model.info.ColumnDecorator;
import pl.psnc.vlab.util.gui.model.info.ColumnInfo;
import pl.psnc.vlab.util.gui.model.info.ColumnType;

/**
 * {@link WfmColumnType} class - describes JTable column type. Each column is
 * described by column name, type. Column names are Internationalised.
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public enum WfmColumnType implements ColumnInfo {

	// CCF Editor columns
	CCF_FREQUENCY("table.header.ccf.frequency", String.class),
	CCF_BANDWIDTH("table.header.ccf.bandwidth", String.class),
	CCF_SIDEBAND("table.header.ccf.sideband", String.class),
	CCF_POLARISATION("table.header.ccf.polarisation", String.class),
	
	CCF_STATION("table.header.ccf.station", String.class),
	CCF_DATA_SOURCE("table.header.ccf.data.source", String.class),
	
	CCF_SITE_POSITION_X("table.header.ccf.site.position.x", String.class);

	/** Stores instance of field: column */
	private ColumnInfo column;

	/**
	 * Creates new ColumnType
	 * 
	 * @param tName column name
	 * @param type column type
	 */
	private WfmColumnType(String nameKey, Class<?> type) {
		this(nameKey, type, null);
	}

	/**
	 * Creates new ColumnType
	 * 
	 * @param nameKey column name i18n key
	 * @param type column type
	 * @param decorator decorator class
	 */
	private WfmColumnType(String nameKey, Class<?> type, ColumnDecorator decorator) {
		this(nameKey, type, decorator, null);
	}

	/**
	 * Creates new ColumnType
	 * 
	 * @param nameKey column name i18n key
	 * @param type column type
	 * @param decorator decorator class
	 * @param comparator comparator class
	 */
	private WfmColumnType(String nameKey, Class<?> type, ColumnDecorator decorator,
			Comparator<?> comparator) {
		this.column = new WfmColumn(nameKey, type, decorator, comparator);
	}

	// -----------------------------------------------------------------------------------
	// ---- Helper Classes and methods

	/**
	 * {@link WfmColumn} class
	 * 
	 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
	 * @email osa@man.poznan.pl
	 * 
	 */
	private class WfmColumn extends ColumnType {

		/** Stores instance of field: BUNDLE */
		private static final String BUNDLE = "bundle/table";

		/**
		 * Creates new ColumnType
		 * 
		 * @param tName column name
		 * @param type column type
		 */
		public WfmColumn(String nameKey, Class<?> type) {
			this(nameKey, type, null);
		}

		/**
		 * Creates new ColumnType
		 * 
		 * @param nameKey column name i18n key
		 * @param type column type
		 * @param decorator decorator class
		 */
		public WfmColumn(String nameKey, Class<?> type, ColumnDecorator decorator) {
			this(nameKey, type, decorator, null);
		}

		/**
		 * Creates new ColumnType
		 * 
		 * @param nameKey column name i18n key
		 * @param type column type
		 * @param decorator decorator class
		 * @param comparator comparator class
		 */
		public WfmColumn(String nameKey, Class<?> type, ColumnDecorator decorator,
				Comparator<?> comparator) {
			super(nameKey, type, decorator, comparator);
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see pl.psnc.vlab.util.gui.model.info.Column#getBundle()
		 */
		@Override
		public String getBundle() {
			return BUNDLE;
		}

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see pl.psnc.vlab.util.gui.model.info.ColumnInfo#getColumnType()
	 */
	@Override
	public ColumnType getColumnType() {
		return column.getColumnType();
	}

}
