/**
 * 
 */
package pl.psnc.expres.wfm.gui.factory;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;

import javax.swing.JPanel;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import pl.psnc.expres.wfm.exception.WfmException;

/**
 * {@link PaneFactory} class is used to create an instances of JPanel
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public class PaneFactory {

	/** Stores logger instance */
	private static Log log = LogFactory.getLog(PaneFactory.class.getName());

	/** Stores a map with JPanes */
	private static Map<Class<?>, JPanel> paneMap = new HashMap<Class<?>, JPanel>();

	/**
	 * Get a JPanel class identified by the given name
	 * 
	 * @param paneClass JPanel class name
	 * @return JPanel class
	 */
	public static JPanel getJPane(Class<?> paneClass) {
		log.debug("<getJPane:" + paneClass + ">");
		return paneMap.get(paneClass);
	}

	/**
	 * Stores a given JPanel
	 * 
	 * @param pane JPanel to be stored
	 */
	public static void storeJPane(JPanel pane) {
		log.debug("<storeJPane>");
		if (pane == null) {
			log.debug("Pane is null");
			return;
		}

		paneMap.put(pane.getClass(), pane);
	}

	/**
	 * Creates a new instance of JPanel class
	 * 
	 * @param paneClass JPanel class to be created
	 * @return new instance of JPanel class
	 */
	public static <T extends JPanel> JPanel newInstance(Class<T> paneClass)
			throws WfmException {

		try {
			Constructor<T> paneConst = paneClass.getConstructor();
			return paneConst.newInstance();
		} catch (Exception e) {
			throw new WfmException(e.getLocalizedMessage(), e);
		}

	}

}
