/*
 * InitializeDialog.java
 *
 * Created on 9 sierpie� 2004, 12:39
 */

package pl.psnc.expres.wfm.gui.about;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.util.ResourceBundle;

import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.SwingConstants;
import javax.swing.WindowConstants;

import pl.psnc.expres.wfm.util.i18n.helper.BundleFactory;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

/**
 * {@link SplashDialog} class - splash dialog form.
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public class SplashDialog extends javax.swing.JDialog {

	/** Stores instance of field: serialVersionUID */
	private static final long serialVersionUID = 1L;

	/**
	 * Creates new form {@link SplashDialog}
	 * 
	 * @param parent parent frame
	 * @param modal specifies whether dialog is modal
	 */
	public SplashDialog(java.awt.Frame parent, boolean modal) {
		super(parent, modal);
		initComponents();
		String msg = BundleFactory.getMessageValue("message.init");
		jMessageLbl.setText(msg);
	}

	/**
	 * This method is called from within the constructor to initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is always
	 * regenerated by the Form Editor.
	 */
	// <editor-fold defaultstate="collapsed" desc=" Generated Code
	// ">//GEN-BEGIN:initComponents
	// Generated using JFormDesigner non-commercial license
	private void initComponents() {
		ResourceBundle bundle = ResourceBundle.getBundle("bundle.messages");
		jMessageLbl = new JLabel();
		jProgressBar = new JProgressBar();
		jImageLbl = new JLabel();
		CellConstraints cc = new CellConstraints();

		// ======== this ========
		setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
		setModal(true);
		setResizable(false);
		setUndecorated(true);
		Container contentPane = getContentPane();
		contentPane.setLayout(new FormLayout("default:grow",
				"top:240px, default, 23px, default, 30px"));

		// ---- jMessageLbl ----
		jMessageLbl.setFont(new Font("Monospaced", Font.PLAIN, 11));
		jMessageLbl.setHorizontalAlignment(SwingConstants.CENTER);
		jMessageLbl.setText(bundle.getString("message.init"));
		jMessageLbl.setHorizontalTextPosition(SwingConstants.CENTER);
		jMessageLbl.setMaximumSize(new Dimension(1400, 10));
		jMessageLbl.setMinimumSize(new Dimension(2, 10));
		jMessageLbl.setPreferredSize(new Dimension(50, 10));
		contentPane.add(jMessageLbl, cc.xy(1, 2));

		// ---- jProgressBar ----
		jProgressBar.setForeground(new Color(0, 88, 38));
		jProgressBar.setValue(10);
		jProgressBar.setBorder(Borders.createEmptyBorder("0dlu, 0dlu, 0dlu, 0dlu"));
		jProgressBar.setBorderPainted(false);
		jProgressBar.setEnabled(false);
		jProgressBar.setIndeterminate(true);
		jProgressBar.setMaximumSize(new Dimension(32767, 4));
		jProgressBar.setMinimumSize(new Dimension(10, 3));
		jProgressBar.setOpaque(false);
		jProgressBar.setPreferredSize(new Dimension(150, 4));
		jProgressBar.setVerifyInputWhenFocusTarget(false);
		contentPane.add(jProgressBar, cc.xy(1, 4));

		// ---- jImageLbl ----
		jImageLbl.setIcon(new ImageIcon(getClass().getResource("/images/vlab/splash_0.2.jpg")));
		jImageLbl.setIconTextGap(0);
		contentPane.add(jImageLbl, cc.xywh(1, 1, 1, 5));
		setSize(410, 385);
		setLocationRelativeTo(null);
	}

	// </editor-fold>//GEN-END:initComponents

	// Variables declaration - do not modify//GEN-BEGIN:variables
	// Generated using JFormDesigner non-commercial license
	private JLabel jMessageLbl;
	private JProgressBar jProgressBar;
	private JLabel jImageLbl;

	// End of variables declaration//GEN-END:variables

	/**
	 * Set the status message
	 * 
	 * @param msg
	 */
	public void setMessage(String msg) {
		jMessageLbl.setText(msg);
	}

}
