/*
 * Created by JFormDesigner on Tue Apr 29 14:06:54 CEST 2008
 */

package pl.psnc.expres.wfm.graph;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.ResourceBundle;

import javax.swing.JMenu;
import javax.swing.JMenuItem;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgraph.JGraph;
import org.jgraph.graph.DefaultGraphCell;

import pl.psnc.expres.model.experiment.VlbiExperiment;
import pl.psnc.expres.model.factory.ResourceTypeFactory;
import pl.psnc.expres.model.factory.VlbiExperimentFactory;
import pl.psnc.expres.model.resource.ResourceValue;
import pl.psnc.expres.model.type.ResourceType;
import pl.psnc.expres.model.type.value.CorrelatorType;
import pl.psnc.expres.model.type.value.FileServerType;
import pl.psnc.graph.factory.GraphCellFactory;
import pl.psnc.graph.factory.GraphEditorFactory;
import pl.psnc.graph.gui.JGraphPane;
import pl.psnc.graph.gui.popup.JCustomGraphPopup;
import pl.psnc.vlab.exception.ResourceNotFoundException;
import pl.psnc.vlab.util.gui.message.JMessage;
import pl.psnc.vlab.util.image.ImageBean;
import pl.psnc.vlab.util.image.ImageFactory;

/**
 * {@link JReferencePopup} class - default add wfm resource popup menu
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public class JReferencePopup extends JCustomGraphPopup {

	/** Default serial uid */
	private static final long serialVersionUID = 1L;

	/** Stores instance of field: log */
	private Log log = LogFactory.getLog(JReferencePopup.class);

	/** Stores instance of field: mouseEvent */
	private final MouseEvent mouseEvent;

	/** Stores instance of field: graph */
	private final JGraph graph;

	/** Stores instance of field: vlbi experiment */
	private VlbiExperiment vlbiExp;

	/**
	 * Creates a new instance of JCustomGraphPopup
	 * 
	 * @throws ResourceNotFoundException
	 */
	public JReferencePopup(List<ResourceValue> resourceList, JGraph graph, MouseEvent mouseEvent)
			throws ResourceNotFoundException {
		this.graph = graph;
		this.mouseEvent = mouseEvent;
		initComponents();
		initFormComponents(resourceList);
		vlbiExp = VlbiExperimentFactory.getInstance();
	}

	/**
	 * Initialise form components
	 */
	@SuppressWarnings("unused")
	private void initComponents() {
		// JFormDesigner - Component initialization - DO NOT MODIFY
		// //GEN-BEGIN:initComponents
		// Generated using JFormDesigner non-commercial license
		ResourceBundle bundle = ResourceBundle.getBundle("bundle.jgraph");
		jAddFileServerMenu = new JMenu();
		jAddCorrelatorMenu = new JMenu();

		//======== this ========
		setName("this");
		addSeparator();

		//======== jAddFileServerMenu ========
		{
			jAddFileServerMenu.setText(bundle.getString("custom.graph.popup.jAddFileServerMenu.text"));
			jAddFileServerMenu.setName("jAddFileServerMenu");
		}
		add(jAddFileServerMenu);

		//======== jAddCorrelatorMenu ========
		{
			jAddCorrelatorMenu.setText(bundle.getString("custom.graph.popup.jAddCorrelatorMenu.text"));
			jAddCorrelatorMenu.setName("jAddCorrelatorMenu");
		}
		add(jAddCorrelatorMenu);
		// //GEN-END:initComponents
	}

	// JFormDesigner - Variables declaration - DO NOT MODIFY
	// //GEN-BEGIN:variables
	// Generated using JFormDesigner non-commercial license
	private JMenu jAddFileServerMenu;
	private JMenu jAddCorrelatorMenu;
	// JFormDesigner - End of variables declaration //GEN-END:variables

	// ----------------------------------------------------------------------------------------
	// ---- Private helper methods

	/**
	 * Initialise form components
	 * 
	 * @throws ResourceNotFoundException
	 */
	private void initFormComponents(List<ResourceValue> resourceList)
			throws ResourceNotFoundException {
		log.debug("<initFormComponents>");
		if (resourceList == null) {
			log.debug("Resource list is EMPTY");
			return;
		}

		for (ResourceValue rValue : resourceList) {
			int typeId = rValue.getTypeId();
			ResourceType resourceType = ResourceTypeFactory.getResourceType(typeId);
			if (resourceType == null) {
				log.debug("ResourceType is NULL");
				continue;
			}
			String icon = resourceType.getDecorator().getIcon();
			ImageBean imageBean = ImageFactory.getImageBean(icon);
			JMenuItem menuItem = new JMenuItem(rValue.getName(), imageBean.getImage());
			menuItem.setToolTipText(rValue.getDescription());
			menuItem.addActionListener(new ResourceActionListener(rValue));

			if (resourceType instanceof CorrelatorType) {
				log.debug("Addding correlator");
				jAddCorrelatorMenu.add(menuItem);
			} else if (resourceType instanceof FileServerType) {
				log.debug("Addding file server");
				jAddFileServerMenu.add(menuItem);
			}
		} // end of for
		log.debug("</initFormComponents>");
	}

	// -----------------------------------------------------------------------------------
	// ---- Private Helper Classes

	/**
	 * {@link ResourceActionListener} class - resource action listener
	 * 
	 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
	 * @email osa@man.poznan.pl
	 * 
	 */
	private class ResourceActionListener implements ActionListener {

		/** Stores instance of field: resourceValue */
		private final ResourceValue resourceValue;

		public ResourceActionListener(ResourceValue resourceValue) {
			this.resourceValue = resourceValue;

		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
		 */
		@Override
		public void actionPerformed(ActionEvent e) {
			int typeId = resourceValue.getTypeId();
			ResourceType resourceType;
			try {
				
				//add resource to scenario
				vlbiExp.getResources().add(resourceValue);
				
				//add resource to graph
				resourceType = ResourceTypeFactory.getResourceType(typeId);
				JGraphPane graphEditor = GraphEditorFactory.getGraphEditorInstance();
				DefaultGraphCell vertex = GraphCellFactory.createCell(resourceType, resourceValue);
				graphEditor.insert(mouseEvent.getPoint(), vertex);
			} catch (Exception error) {
				JMessage.showErrorMessage(null, error);
			}
		}
	}

	// -----------------------------------------------------------------------------------
	// ---- Private Helper Classes

	/**
	 * Get value of field: graph
	 * 
	 * @return the graph
	 */
	public JGraph getGraph() {
		return graph;
	}

	/**
	 * Get value of field: vlbiExp
	 * @return the vlbiExp
	 */
	public VlbiExperiment getVlbiExp() {
		return vlbiExp;
	}

	/**
	 * Set value of field: vlbiExp
	 * @param vlbiExp the vlbiExp to set
	 */
	public void setVlbiExp(VlbiExperiment vlbiExp) {
		this.vlbiExp = vlbiExp;
	}

	
}
