/*
 * EventLogValue.java
 *
 * Created on 7 czerwiec 2005, 16:30
 *
 */

package pl.psnc.expres.wfm.event.value;
import java.util.Date;

import pl.psnc.expres.wfm.event.type.MsgErrorEvent;
import pl.psnc.expres.wfm.event.type.MsgEventType;

/**
 * The value object for the log events
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 */
public class EventLogValue implements Comparable{
    
    
    /** Stores type of this event message */
    private MsgEventType type;
    
    /** Holds value of property message. */
    private String message;
    
    /** The occurence of the event */
    private Date occurenceDate;
    
    /** The message details */
    private Object details;
    
    
    
    /**
     * Creates a new instance of EventLogValue with empty content
     */
    public EventLogValue() {
        
    }
    
    /**
     * Creates a new instance of EventLogValue with the its content defined
     * @param details the message details (it may be an exception in case of ErrorEvent) 
     * @param occurenceDate date of the event
     * @param type the type of the log message (Information, Error, etc.)
     * @param message the event message
     */
    public EventLogValue(String message, Date occurenceDate, MsgEventType type, Object details) {
        this.message = message;
        this.type = type;
        this.occurenceDate = occurenceDate;
        this.details = details;
    }
    
    
    /**
     * Creates a new instance of EventLogValue with the its content defined
     * @param occurenceDate date of the event
     * @param type the type of the log message (Information, Error, etc.)
     * @param message the event message
     */
    public EventLogValue(String message, Date occurenceDate, MsgEventType type) {
        this(message, occurenceDate, type, null);
    }
    
    
    /**
     * Creates a new instance of EventLogValue with the its content defined
     * @param type the type of the log message (Information, Error, etc.)
     * @param message the event message
     */
    public EventLogValue(String message, MsgEventType type) {
        this(message, new Date(), type, null);
    }
    
    
    /** Get type of this event message
     * @return type
     */
    public MsgEventType getType() {
        return this.type;
    }
    
    
    
    /**
     * Getter for property message.
     * @return Value of property message.
     */
    public String getMessage() {        
        return message != null ? this.message : "";
    }
    
    /**
     * Setter for property message.
     * @param message New value of property message.
     */
    public void setMessage(String message) {        
        this.message = message;
    }
    
    /** Get the occurence time */
    public Date getDate(){        
        return this.occurenceDate;
    }
    
    
    /** Get detailed information about this event message */
    public String getDetails(){
        if(details == null){
            return "";
        }
        if(type instanceof MsgErrorEvent){
            return ( (Exception) details).getMessage();
        }
        return details.toString();
    }
    
    
    
    
    /**
     * Compares this object with the specified object for order.  Returns a
     * negative integer, zero, or a positive integer as this object is less
     * than, equal to, or greater than the specified object.<p>
     *
     * In the foregoing description, the notation
     * <tt>sgn(</tt><i>expression</i><tt>)</tt> designates the mathematical
     * <i>signum</i> function, which is defined to return one of <tt>-1</tt>,
     * <tt>0</tt>, or <tt>1</tt> according to whether the value of <i>expression</i>
     * is negative, zero or positive.
     *
     * The implementor must ensure <tt>sgn(x.compareTo(y)) ==
     * -sgn(y.compareTo(x))</tt> for all <tt>x</tt> and <tt>y</tt>.  (This
     * implies that <tt>x.compareTo(y)</tt> must throw an exception iff
     * <tt>y.compareTo(x)</tt> throws an exception.)<p>
     *
     * The implementor must also ensure that the relation is transitive:
     * <tt>(x.compareTo(y)&gt;0 &amp;&amp; y.compareTo(z)&gt;0)</tt> implies
     * <tt>x.compareTo(z)&gt;0</tt>.<p>
     *
     * Finally, the implementer must ensure that <tt>x.compareTo(y)==0</tt>
     * implies that <tt>sgn(x.compareTo(z)) == sgn(y.compareTo(z))</tt>, for
     * all <tt>z</tt>.<p>
     *
     * It is strongly recommended, but <i>not</i> strictly required that
     * <tt>(x.compareTo(y)==0) == (x.equals(y))</tt>.  Generally speaking, any
     * class that implements the <tt>Comparable</tt> interface and violates
     * this condition should clearly indicate this fact.  The recommended
     * language is "Note: this class has a natural ordering that is
     * inconsistent with equals."
     *
     * @param   o the Object to be compared.
     * @return  a negative integer, zero, or a positive integer as this object
     * 		is less than, equal to, or greater than the specified object.
     *
     * @throws ClassCastException if the specified object's type prevents it
     *         from being compared to this Object.
     */
    public int compareTo(Object o) {
        if(!(o instanceof EventLogValue)){
            return -1;
        }
        if(occurenceDate == null){    //case for the empty lines
            return 1;
        }
        EventLogValue event = (EventLogValue) o;
        if(event.occurenceDate == null){    //case for the empty lines
            return -1;
        }
        //int res = dateAndTime.compareTo( ((EventLogValue)o).dateAndTime) * (-1);
        int res = occurenceDate.compareTo( ((EventLogValue)o).occurenceDate) * (-1);
        return res;
    }
    
}