/*
 * MsgErrorEvent.java
 *
 * Created on January 12, 2006, 11:34 AM
 *
 */

package pl.psnc.expres.wfm.event.type;

import pl.psnc.vlab.util.image.ImageFactory;

/**
 * Messge Log Type - information message
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 */
public class MsgInfoEvent extends MsgEventType {
    
    /** Stores error event icon */
    private static final String INFO_ICON = "images/dialog/message_info.gif";
    
    /** Stores an instance of MsgErrorEvent */
    private static MsgInfoEvent instance;
    
    /** Creates a new instance of MsgErrorEvent */
    private MsgInfoEvent() {
        super(ImageFactory.getImageBean(INFO_ICON).getImage(), "info.event.type.name");
    }

    /**
     * Get specified event type.
     * @return message event type.
     */
    public static MsgEventType getType() {
        return instance == null ? instance = new MsgInfoEvent() : instance;
    }   
}
