/*
 * EventLogFactory.java
 *
 * Created on January 17, 2006, 10:21 AM
 *
 */

package pl.psnc.expres.wfm.event;

import pl.psnc.expres.wfm.event.type.MsgErrorEvent;
import pl.psnc.expres.wfm.event.type.MsgInfoEvent;
import pl.psnc.expres.wfm.event.value.EventLogValue;

/**
 * Abstract factory class for logging the system events
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 */
public abstract class EventLogFactory {
    
    /** Stores an instance of Log Event Table Model */
    private static EventLogTableModel tableModel = new EventLogTableModel();
    
    
    /**
     * Get the table model of the event log message table
     * @return table model
     */
    public static EventLogTableModel getTableModel(){
        if(tableModel == null){
            tableModel = new EventLogTableModel();
        }
        return tableModel;
    }
    
    /**
     * Add information message to the Message Log
     * @param message information message to be displayed
     */
    public static void addInfoMessage(String message){
        tableModel.addLogEvent(new EventLogValue(message, MsgInfoEvent.getType()));
    }
    
     /**
     * Add error message to the Message Log
     * @param message error message to be displayed
     */
    public static void addErrorMessage(String message){
        tableModel.addLogEvent(new EventLogValue(message, MsgErrorEvent.getType()));
    }
    
}
