package pl.psnc.expres.wfm.action.perspective;

import java.awt.event.ActionEvent;
import java.util.Observable;
import java.util.Observer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import pl.psnc.expres.wfm.action.factory.WfmAbstractAction;
import pl.psnc.expres.wfm.gui.perspective.workflow.WorkflowDesignPane;
import pl.psnc.expres.wfm.util.ImageKeys;
import pl.psnc.vlab.util.gui.message.JMessage;

/**
 * {@link WorkflowEditorViewAction} class - shows workflow editor
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public class WorkflowEditorViewAction extends WfmAbstractAction implements Observer {

	/** Default serial uid */
	private static final long serialVersionUID = 1L;

	/** Instance of logger */
	private Log log = LogFactory.getLog(WorkflowEditorViewAction.class);

	/**
	 * Creates a new instance of WorkflowEditorViewAction. The action is created
	 * with the default name, icons, mnemonic and accelerator key - these are
	 * taken from the resource bundle
	 */
	public WorkflowEditorViewAction() {
		super("action.workflow.editor.view.name", ImageKeys.VIEW_WORKFLOW_EDITOR,
				"action.workflow.editor.view.tip");
	}

	/**
	 * @see java.awt.event.ActionListener#actionPerformed(ActionEvent)
	 */
	public void actionPerformed(ActionEvent e) {
		try {
			log.debug("<actionPerformed>");
			setEnabled(true);
			mainFrame.getJWorkflowEditorTBtn().setSelected(true);
			mainFrame.addMainContentPane(WorkflowDesignPane.class, true);
			// notify all observers
			notifyObservers(this);
		} catch (Exception error) {
			JMessage.showErrorMessage(mainFrame, error);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.util.Observer#update(java.util.Observable, java.lang.Object)
	 */
	@Override
	public void update(Observable o, Object arg) {
		log.debug("<update: WorkflowEditorViewAction>");
		if (arg instanceof CcfEditorPaneAction) {
			CcfEditorPaneAction action = (CcfEditorPaneAction) arg;
			mainFrame.getJWorkflowEditorTBtn().setSelected(!action.isEnabled());
		}
		log.debug("</update>");
	}

}
