package pl.psnc.expres.wfm.action.perspective;

import java.awt.event.ActionEvent;

import javax.swing.AbstractButton;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import pl.psnc.expres.wfm.action.factory.WfmAbstractAction;
import pl.psnc.expres.wfm.util.ImageKeys;

/**
 * {@link ResInfPerspAction} class - The Resource Information Perspective Action
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public class ResInfPerspAction extends WfmAbstractAction {

	/** Default serial uid */
	private static final long serialVersionUID = 1L;

	/** Instance of logger */
	private Log log = LogFactory.getLog(this.getClass().getName());

	/** List of parents object */
	private Object parent[];

	/**
	 * Creates a new instance of ResInfPerspAction. The action is created with
	 * the default name, icons, mnemonic and accelerator key - these are taken
	 * from the resource bundle
	 * 
	 * @param parent parent object, which is bundled to this action
	 */
	public ResInfPerspAction(Object parent[]) {
		super("action.resource.info.pers.name", ImageKeys.ICON_RESOURCE_INFO_VIEW,
				"action.resource.info.pers.tip");
		setMnemonic("action.resource.info.pers.mnemonic");
		setAcceleratorKey("action.resource.info.pers.shortcut");
		this.parent = parent;
	}

	/**
	 * @see java.awt.event.ActionListener#actionPerformed(ActionEvent)
	 */
	public void actionPerformed(ActionEvent e) {
		setVisible(!isVisible());
		if (e == null) { // action was called manually
			((AbstractButton) parent[0]).setSelected(isVisible());
			((AbstractButton) parent[1]).setSelected(isVisible());
		} else if (e.getSource() == parent[0]) {
			((AbstractButton) parent[1]).setSelected(isVisible());
		} else if (e.getSource() == parent[1]) {
			((AbstractButton) parent[0]).setSelected(isVisible());
		}
		log.debug("Visible-" + isVisible());
		// TODO impl
		// mainFrameBase.setResourceOutlineVisible(isVisible());
	}

	/**
	 * Holds value of property visible.
	 */
	private boolean visible;

	/**
	 * Getter for property visible.
	 * 
	 * @return Value of property visible.
	 */
	public boolean isVisible() {

		return this.visible;
	}

	/**
	 * Setter for property visible.
	 * 
	 * @param visible New value of property visible.
	 */
	public void setVisible(boolean visible) {

		this.visible = visible;
	}
}
