package pl.psnc.expres.wfm.action.perspective;

import java.awt.event.ActionEvent;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import pl.psnc.expres.wfm.action.factory.WfmAbstractAction;
import pl.psnc.expres.wfm.util.ImageKeys;

/**
 * {@link EventLogPerspAction} class - the event log perspective action
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public class EventLogPerspAction extends WfmAbstractAction {

	/** Default serial uid */
	private static final long serialVersionUID = 1L;

	/** Instance of logger */
	private Log log = LogFactory.getLog(this.getClass().getName());

	/**
	 * Creates a new instance of zoom in Action. The action is created with the
	 * default name, icons, mnemonic and accelerator key - these are taken from
	 * the resource bundle
	 */
	public EventLogPerspAction() {
		super("action.msg.log.pers.name", ImageKeys.ICON_MESSAGE_LOG_VIEW,
				"action.msg.log.pers.tip");
		setMnemonic("action.msg.log.pers.mnemonic");
		setAcceleratorKey("action.msg.log.pers.shortcut");
		setDisabledActionIcon(ImageKeys.ICON_MESSAGE_LOG_VIEW_DISABLED);
	}

	/**
	 * @see java.awt.event.ActionListener#actionPerformed(ActionEvent)
	 */
	public void actionPerformed(ActionEvent e) {
		setVisible(!isVisible());
		log.debug("Visibled-" + isVisible());
		// TODO impl
		// mainFrameBase.setMessageLogVisible(isVisible());
	}

	/**
	 * Holds value of property visible.
	 */
	private boolean visible;

	/**
	 * Getter for property visible.
	 * 
	 * @return Value of property visible.
	 */
	public boolean isVisible() {

		return this.visible;
	}

	/**
	 * Setter for property visible.
	 * 
	 * @param visible New value of property visible.
	 */
	public void setVisible(boolean visible) {

		this.visible = visible;
	}
}
