package pl.psnc.expres.wfm.action.perspective;

import java.awt.event.ActionEvent;
import java.util.Observable;
import java.util.Observer;

import javax.swing.JToggleButton;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import pl.psnc.expres.wfm.action.factory.WfmAbstractAction;
import pl.psnc.expres.wfm.gui.perspective.ccf.CcfEditorView;
import pl.psnc.expres.wfm.util.ImageKeys;
import pl.psnc.vlab.util.gui.message.JMessage;

/**
 * {@link CcfEditorPaneAction} class - shows correlator control file editor
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public class CcfEditorPaneAction extends WfmAbstractAction implements Observer {

	/** Default serial uid */
	private static final long serialVersionUID = 1L;

	/** Instance of logger */
	private Log log = LogFactory.getLog(this.getClass().getName());

	/**
	 * Creates a new instance of CcfEditorPaneAction. The action is created with
	 * the default name, icons, mnemonic and accelerator key - these are taken
	 * from the resource bundle
	 */
	public CcfEditorPaneAction() {
		super("action.ccf.editor.pane.name", ImageKeys.VIEW_CCF_EDITOR,
				"action.ccf.editor.pane.tip");
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see pl.psnc.vlab.util.gui.action.AbstractActionDefault#actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(ActionEvent e) {
		try {
			log.debug("<actionPerformed>");
			setEnabled(true);
			mainFrame.addMainContentPane(CcfEditorView.class, true);
			notifyObservers(this);
		} catch (Exception err) {
			JMessage.showErrorMessage(mainFrame, err);
		}
	}

	/* (non-Javadoc)
	 * @see java.util.Observer#update(java.util.Observable, java.lang.Object)
	 */
	@Override
	public void update(Observable o, Object arg) {
		log.debug("<update: CcfEditorPaneAction>");
		if(arg instanceof WorkflowEditorViewAction ){
			WorkflowEditorViewAction workflowAction = (WorkflowEditorViewAction) arg;
			JToggleButton ccfEditorTBtn = mainFrame.getJCcfEditorTBtn();
			ccfEditorTBtn.setEnabled(true);
			ccfEditorTBtn.setSelected(!workflowAction.isEnabled());
		}
		log.debug("</update>");
	}

	
	
}
