/**
 * WfmActionHelper.java
 * Created on Feb 8, 2008
 */
package pl.psnc.expres.wfm.action.factory;

import javax.swing.AbstractButton;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import pl.psnc.vlab.exception.ResourceNotFoundException;
import pl.psnc.vlab.util.gui.action.AbstractActionDefault;
import pl.psnc.vlab.util.gui.action.factory.ActionFactory;
import pl.psnc.vlab.util.gui.action.factory.ActionType;
import pl.psnc.vlab.util.gui.action.helper.ActionHelper;

/**
 * {@link WfmActionHelper} class - used to set up actions for the JComponents
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public class WfmActionHelper {

	/** Instance of logger */
	private static Log log = LogFactory.getLog(WfmActionHelper.class.getName());

	/**
	 * Set action for the given component. The tooltip, icons and text are
	 * copied from the given action. If the given component is of type JButton
	 * the empty text will be set
	 * 
	 * @param component swing component, instance of {@link AbstractButton}
	 * @param type action type, instance of {@link WfmActionType}
	 * @param enabled specifies whether action is enabled
	 * @throws ResourceNotFoundException thrown when action could not be initialized
	 */
	public static void setAction(AbstractButton component, ActionType type,
			boolean enabled) throws ResourceNotFoundException {
		log.debug("<setAction>");
		AbstractActionDefault action = ActionFactory.getAction(type);
		if (action == null) {
			log.warn("Action was not found. Type=" + type);
			return;
		}
		ActionHelper.setAction(component, action, enabled);
	}

}
