package pl.psnc.expres.wfm.action.factory;

import org.jgraph.graph.GraphLayoutCache;

import pl.psnc.expres.wfm.gui.main.JMainFrame;
import pl.psnc.graph.exception.GraphException;
import pl.psnc.graph.factory.GraphEditorFactory;
import pl.psnc.graph.gui.JGraphPane;
import pl.psnc.graph.model.CustomGraph;
import pl.psnc.vlab.util.gui.action.LocalizedObservableAbstractAction;

/**
 * {@link WfmAbstractAction} class - provides default implementations for the
 * JFC Action interface used in the WFM application. All string values are
 * internationalized.
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public abstract class WfmAbstractAction extends LocalizedObservableAbstractAction {

	/** Stores instance of field: BUNDLE */
	private static final String BUNDLE = "bundle/gui";

	/** Instance of JMainFrame */
	protected JMainFrame mainFrame;

	/**
	 * Define an Action Object with a specified action name, icon and short
	 * description.
	 * 
	 * @param nameKey name of the action
	 * @param iconPath the icon for the current action
	 * @param description action short description
	 */
	public WfmAbstractAction(String nameKey, String iconPath, String description) {
		super(nameKey, iconPath, description);
		this.mainFrame = JMainFrame.getInstance();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see pl.psnc.vlab.util.gui.action.LocalizedAbstractAction#getBundle()
	 */
	@Override
	public String getBundle() {
		return BUNDLE;
	}

	/**
	 * Return an instance of the current Scenario Graph for the current Graph
	 * Editor.
	 * 
	 * @return instance of the current Scenario Graph for the current Graph
	 */
	public CustomGraph getCurrentGraph() throws GraphException {
		JGraphPane graphEditorInstance = GraphEditorFactory.getGraphEditorInstance();
		return graphEditorInstance != null ? graphEditorInstance.getGraph() : null;
	}

	/**
	 * Get the current Graph Layout Cache
	 * 
	 * @return current Graph Layout Cache
	 */
	public GraphLayoutCache getCurrentGraphLayoutCache() throws GraphException {
		CustomGraph graph = getCurrentGraph();
		if (graph != null) {
			return graph.getGraphLayoutCache();
		} else {
			return null;
		}
	}

}
