package pl.psnc.expres.wfm.action;

import java.awt.event.ActionEvent;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import pl.psnc.expres.wfm.action.factory.WfmAbstractAction;
import pl.psnc.expres.wfm.event.EventLogFactory;
import pl.psnc.expres.wfm.util.ImageKeys;
import pl.psnc.vlab.exception.VlabException;
import pl.psnc.vlab.util.gui.message.JMessage;

/**
 * {@link NewScenarioAction} class - used for creating a new dynamic scenario
 * 
 * @author Dominik Stoklosa
 * @email osa@man.poznan.pl
 */
public class NewScenarioAction extends WfmAbstractAction {

	/** Default serial uid */
	private static final long serialVersionUID = 1L;

	/** Instance of logger */
	private Log log = LogFactory.getLog(this.getClass().getName());

	/**
	 * Creates a new instance of new Action. The new action is used to create a
	 * new empty dynamic scenario. The action is created with the default name,
	 * icons, mnemonic and accelerator key - these are taken from the resource
	 * bundle
	 * 
	 */
	public NewScenarioAction() {
		super("action.new.name", ImageKeys.ICON_NEW, "action.new.tip");
		setMnemonic("action.new.mnemonic");
		setAcceleratorKey("action.new.shortcut");
	}

	/**
	 * @see java.awt.event.ActionListener#actionPerformed(ActionEvent)
	 */
	public void actionPerformed(ActionEvent e) {
		try {
			// check whether the current graph is empty
			// CustomGraph graph = getCurrentGraph();
			// int result = 0;
			// if (graph != null && !graph.isEmpty()
			// &&
			// ActionFactory.getAction(WfmActionType.SCENARIO_SAVE).isEnabled())
			// {
			// log.debug("An old secenario exists");
			// String msg = MessageBundleFactory
			// .getValue("message.another.scenario.in.use");
			// result = JMessage.showConfirmQuestionMessage(mainFrame, msg,
			// JMessage.YES_NO_OPTION);
			// if (result != JMessage.YES_OPTION) {
			// log.debug("Do not close scenario");
			// return;
			// }
			// }
			// TODO impl
			// mainFrame.installGraph();
			// mainFrame.getBasePane().getJScenDetailsPane().update(null,
			// ScenarioBuilder.getExperimentDetails());
			EventLogFactory.addInfoMessage("New scenario created");

			// remove save chooser
			// FileChooserFactory.removeChooser(FileChooserFactory.TYPE_SAVE_DIALOG);

			updateActions(e);
		} catch (Exception err) {
			log.error("Error" + err.getMessage());
			JMessage.showErrorMessage(mainFrame, err.getLocalizedMessage());
		}
	}

	/**
	 * Update actions
	 * 
	 * @param e instance of {@link ActionEvent}
	 * @throws VlabException thrown when update fails
	 */
	private void updateActions(ActionEvent e) throws VlabException {
		// disable actions

		// ActionFactory.getAction(WfmActionType.SCENARIO_SUBMIT).setEnabled(false);
		// ActionFactory.getAction(WfmActionType.SCENARIO_SAVE).setEnabled(false);
		// ActionFactory.getAction(WfmActionType.SCENARIO_SAVE_AS).setEnabled(false);
		//
		// // enable actions
		// ActionFactory.getAction(WfmActionType.SCENARIO_CLOSE).setEnabled(true);
		// ActionFactory.getAction(WfmActionType.ZOOM_1_1).setEnabled(true);
		// ActionFactory.getAction(WfmActionType.ZOOM_IN).setEnabled(true);
		// ActionFactory.getAction(WfmActionType.ZOOM_OUT).setEnabled(true);
		// ActionFactory.getAction(WfmActionType.PERSPECTIVE_WELCOME).setEnabled(true);
		// ActionFactory.getAction(WfmActionType.SCENARIO_PROPERTIES).setEnabled(true);
		// Action resOutline =
		// ActionFactory.getAction(WfmActionType.PERSPECTIVE_RESOURCE_OUTLINE);
		// resOutline.setEnabled(true);
		// resOutline.actionPerformed(e);
		// TODO impl
		// ActionFactory.getAction(WfmActionType.ACTION_ADD_VERTEX_COMPUTE).setEnabled(true);
		// ActionFactory.getAction(WfmActionType.ACTION_ADD_VERTEX_EXPERIMENT).setEnabled(true);

	}
}
