package pl.psnc.expres.wfm.action;

import java.awt.event.ActionEvent;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import pl.psnc.expres.wfm.action.factory.WfmAbstractAction;
import pl.psnc.expres.wfm.action.factory.WfmActionType;
import pl.psnc.expres.wfm.event.EventLogFactory;
import pl.psnc.expres.wfm.util.i18n.helper.BundleFactory;
import pl.psnc.graph.action.factory.GraphActionType;
import pl.psnc.graph.model.CustomGraph;
import pl.psnc.graph.util.GraphHelper;
import pl.psnc.vlab.util.gui.action.factory.ActionFactory;
import pl.psnc.vlab.util.gui.message.JMessage;

/**
 * Close Scenario Action is used for closing existing workflow
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public class CloseScenarioAction extends WfmAbstractAction {

	/** Default serial uid */
	private static final long serialVersionUID = 1L;

	/** Instance of logger */
	private Log log = LogFactory.getLog(this.getClass().getName());

	/**
	 * Creates a new instance of new Action. The new action is used to create a
	 * new empty dynamic scenario. The action is created with the default name,
	 * icons, mnemonic and accelerator key - these are taken from the resource
	 * bundle
	 * 
	 * @param source the source swing component, which uses this action
	 */
	public CloseScenarioAction() {
		super("action.close.scen.name", null, "action.close.scen.tip");
		setMnemonic("action.close.scen.mnemonic");
		setAcceleratorKey("action.close.scen.shortcut");
	}

	/**
	 * @see java.awt.event.ActionListener#actionPerformed(ActionEvent)
	 */
	public void actionPerformed(ActionEvent e) {
		try {
			// check whether the current graph is empty
			CustomGraph graph = getCurrentGraph();
			int result = 0;
			if (GraphHelper.isEmpty(graph)
					&& ActionFactory.getAction(WfmActionType.SCENARIO_SAVE).isEnabled()) {
				log.debug("An old secenario exists");
				String msg = BundleFactory.getMessageValue("message.another.scenario.in.use");
				result = JMessage
						.showConfirmQuestionMessage(mainFrame, msg, JMessage.YES_NO_OPTION);
				log.debug("result=" + result);
				if (result != JMessage.YES_OPTION) {
					log.debug("Do not close scenario");
					return;
				}
			}
			// TODO impl
			// mainFrame.installGraph();
			EventLogFactory.addInfoMessage("Scenario closed");
			// tbd removed
			// mainFrame.getBasePane().getJScenDetailsPane().update(null,
			// ScenarioBuilder.getScenarioDescription());

			// remove save chooser
			// FileChooserFactory.removeChooser(FileChooserFactory.TYPE_SAVE_DIALOG);

			// disable actions
			// ActionFactory.getAction(ActionType.WfmActionType).setEnabled(false);
			// ActionFactory.getAction(ActionType.WfmActionType).setEnabled(false);
			// ActionFactory.getAction(ActionType.WfmActionType).setEnabled(false);

			ActionFactory.getAction(WfmActionType.SCENARIO_SUBMIT).setEnabled(false);
			ActionFactory.getAction(WfmActionType.SCENARIO_SAVE).setEnabled(false);
			ActionFactory.getAction(WfmActionType.SCENARIO_SAVE_AS).setEnabled(false);

			// enable actions
			ActionFactory.getAction(GraphActionType.ZOOM_ACTUAL_SIZE).setEnabled(true);
			ActionFactory.getAction(GraphActionType.ZOOM_IN).setEnabled(true);
			ActionFactory.getAction(GraphActionType.ZOOM_OUT).setEnabled(true);

			// TODO impl
			// ActionFactory.getAction(ActionFactory.ACTION_ADD_VERTEX_COMPUTE).setEnabled(
			// true);
			// ActionFactory.getAction(ActionFactory.ACTION_ADD_VERTEX_EXPERIMENT)
			// .setEnabled(true);
		} catch (Exception err) {
			log.error("Error" + err.getMessage());
			JMessage.showErrorMessage(mainFrame, err.getLocalizedMessage());
		}
	}

}
