package pl.psnc.expres.wfm.action;

import java.awt.event.ActionEvent;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgraph.graph.DefaultGraphCell;

import pl.psnc.expres.model.factory.ResourceTypeFactory;
import pl.psnc.expres.model.resource.ResourceValue;
import pl.psnc.expres.model.type.ResourceType;
import pl.psnc.expres.wfm.action.factory.WfmAbstractAction;
import pl.psnc.graph.factory.GraphCellFactory;
import pl.psnc.graph.factory.GraphEditorFactory;
import pl.psnc.graph.gui.JGraphPane;
import pl.psnc.vlab.exception.ResourceNotFoundException;
import pl.psnc.vlab.util.gui.message.JMessage;

/**
 * {@link AddResourceAction} class - add graph resource action
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public class AddResourceAction extends WfmAbstractAction {

	/** Default serial uid */
	private static final long serialVersionUID = 1L;

	/** Instance of logger */
	private Log log = LogFactory.getLog(AddResourceAction.class);

	private final ResourceValue resourceValue;

	/**
	 * Creates a new instance of Exit Action. The action is created with the
	 * default name, icon, mnemonic and accelerator key - these are taken from
	 * the resource bundle
	 */
	public AddResourceAction(ResourceValue resourceValue) {
		super(resourceValue.getName(), null, resourceValue.getDescription());
		this.resourceValue = resourceValue;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see pl.psnc.vlab.util.gui.action.AbstractActionDefault#actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(ActionEvent e) {
		if (resourceValue == null) {
			return;
		}
		try {
			int typeId = resourceValue.getTypeId();
			ResourceType resourceType = ResourceTypeFactory.getResourceType(typeId);
			JGraphPane graphEditor = GraphEditorFactory.getGraphEditorInstance();
			DefaultGraphCell vertex = GraphCellFactory.createCell(resourceType, resourceValue);
			Object source = e.getSource();

			// graphEditor.insert(point, vertex);
		} catch (ResourceNotFoundException error) {
			JMessage.showErrorMessage(mainFrame, error);
		}

	}
}
