package pl.psnc.expres.broker.config;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.fail;

import org.junit.Before;
import org.junit.Test;

import pl.psnc.expres.broker.config.BrokerConfiguration;
import pl.psnc.vlab.conf.ConfigFactory;
import pl.psnc.vlab.exception.VlabException;

public class BrokerConfigurationTest {

	/** Stores instance of field: CONFIG_KEY */
	private static String CONFIG_KEY = "vlbi.broker";

	/** Stores instance of field: CONFIG_LOCATION */
	private static String CONFIG_LOCATION = "/vlbiBroker.properties";

	@Before
	public void setUp() throws Exception {
		ConfigFactory.initConfig(CONFIG_KEY, new BrokerConfiguration(CONFIG_LOCATION));
	}

	@Test
	public void testGetBrokerServiceLocation() {
		try {
			BrokerConfiguration config = (BrokerConfiguration) ConfigFactory.getConfigFactory();
			String brokerServiceLocation = config.getBrokerServiceLocation();
			assertEquals(brokerServiceLocation, "testowy wpis");
		} catch (VlabException e) {
			fail(e.getMessage());
		}

	}

}
