/*
 * Notification.java
 *
 * Created on June 19, 2007, 11:35 AM
 *
 */

package pl.psnc.expres.broker.remote.tn.notification;

import pl.psnc.expres.remote.broker.jobinfo.ChunkInfo;

/**
 * {@link ITranslationNotification} interface - used be Translation Nodes to
 * update listeners about new status of data chunks.
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public interface ITranslationNotification {

	/**
	 * The method is called by the Translation Node to notify the VLBI Broker
	 * that new data chunk is ready
	 * 
	 * @param chunkInfo data chunk value object
	 */
	public void chunkIsReady(ChunkInfo chunkInfo);

}
