/**
 * Created on 23 Jan 2009
 */
package pl.psnc.expres.broker.experiment;

import pl.psnc.expres.model.experiment.VlbiExperiment;

/**
 * {@link CorrelationFactory} class - factory used to manage a correlation
 * session.
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public abstract class CorrelationFactory {

	/** Stores instance of field: correlation value */
	private static CorrelationValue correlationValue;

	/**
	 * Creates new {@link CorrelationFactory}
	 */
	private CorrelationFactory() {
	}

	/**
	 * Get instance of correlation session
	 * 
	 * @return instance of correlation session
	 */
	public static CorrelationValue newInstance(VlbiExperiment vlbiExperiment) {
		correlationValue = new CorrelationValue(vlbiExperiment);
		return correlationValue;
	}

	/**
	 * Get instance of correlation session
	 * 
	 * @return instance of correlation session
	 */
	public static CorrelationValue getInstance() {
		return correlationValue;
	}
}
