/*
 * Configuration.java
 *
 * Created on November 12, 2007, 1:10 PM
 *
 */
package pl.psnc.expres.broker.config;

import pl.psnc.vlab.conf.IConfiguration;

/**
 * {@link IBrokerConfiguration} interface -Vlbi Broker configuration keys
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public interface IBrokerConfiguration extends IConfiguration {

	/** Configuration key - Vlbi Broker service location */
	public static final String BROKER_SERVICE_LOCATION = "broker.service.location";

	/** Configuration key - translation node notification service location */
	public static final String SERVICE_LOCATION_TR_NOTIFICATION = "tn.notification.service.location";

	/**
	 * Get a location of Vlbi Broker service
	 * 
	 * @return location of Vlbi Broker service
	 */
	public String getBrokerServiceLocation();

	/**
	 * Get a location of a tn notification service within Vlbi Broker
	 * 
	 * @return location of a tn notification service within Vlbi Broker
	 */
	public String getTnNotificationServiceLocation();

}
