/*
 * ConfigurationImpl.java
 *
 * Created on November 12, 2007, 1:21 PM
 *
 */
package pl.psnc.expres.broker.config;

import pl.psnc.vlab.conf.ConfigurationImpl;
import pl.psnc.vlab.exception.VlabException;

/**
 * {@link BrokerConfiguration} class
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public class BrokerConfiguration extends ConfigurationImpl implements IBrokerConfiguration {

	/**
	 * Creates a new instance of Vlbi Broker configuration
	 * 
	 * @param configPath configuration path
	 * @throws VlabException thrown when configuration cannot be read
	 */
	protected BrokerConfiguration(String configPath) throws VlabException {
		super(configPath);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see pl.psnc.expres.vlbibroker.config.IBrokerConfiguration#getBrokerServiceLocation()
	 */
	@Override
	public String getBrokerServiceLocation() {
		return getProperty(BROKER_SERVICE_LOCATION);
	}

	/* (non-Javadoc)
	 * @see pl.psnc.expres.vlbibroker.config.IBrokerConfiguration#getTRBrokerServiceLocation()
	 */
	@Override
	public String getTnNotificationServiceLocation() {
		return getProperty(SERVICE_LOCATION_TR_NOTIFICATION);
	}
}
