/**
 * Created on 6 Jan 2009
 */
package pl.psnc.expres.remote.network.monitor.test;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.fail;

import java.util.List;

import org.junit.Before;
import org.junit.Test;

import pl.psnc.expres.model.factory.ResourceFactory;
import pl.psnc.expres.model.resource.ResourceValue;
import pl.psnc.expres.model.resource.helper.ResourceHelper;
import pl.psnc.expres.model.type.value.FileServerType;
import pl.psnc.vlab.exception.ResourceNotFoundException;

/**
 * {@link ResourceHelperTest} class
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public class ResourceHelperTest {

	/** Stores instance of field: PATH */
	private final String PATH = "build/model/resourceList.json";

	/**
	 * @throws java.lang.Exception
	 */
	@Before
	public void setUp() throws Exception {
	}

	/**
	 * Test method for
	 * {@link pl.psnc.expres.model.resource.helper.ResourceHelper#getConcreteTypes(java.util.List, java.lang.Class)}.
	 */
	@Test
	public void testGetConcreteTypes() {
		try {
			List<ResourceValue> resources = ResourceFactory.getResources(PATH);
			List<ResourceValue> concreteTypes = ResourceHelper.getConcreteTypes(resources, FileServerType.class);
			assertEquals(3, concreteTypes.size());
		} catch (ResourceNotFoundException e) {		
			e.printStackTrace();
			fail(e.getLocalizedMessage());
		}
	}
}
