package pl.psnc.expres.remote.network.task;

import java.util.HashMap;
import java.util.Map;


import pl.psnc.expres.model.resource.ResourceValue;
import pl.psnc.expres.remote.network.INetworkMonitorManager;
import pl.psnc.expres.remote.network.executors.Executor;
import pl.psnc.expres.remote.network.executors.ExecutorsFactory;
import pl.psnc.expres.remote.network.parsers.MessageParser;
import pl.psnc.expres.remote.network.parsers.ParsersFactory;

/**
 * Factory used for creation of measurement tasks
 * 
 * @author Lucas Dolata <ldolata@man.poznan.pl>  
 *
 */
public class MeasurementTaskFactory {
	public ParsersFactory getParsers() {
		return parsers;
	}

	public void setParsers(ParsersFactory parsers) {
		this.parsers = parsers;
	}

	/**Parsers factory*/
	private ParsersFactory parsers;
	
	/**Executors factory*/
	private ExecutorsFactory executors;
	
	/**Network monitor*/
	private INetworkMonitorManager manager;
	

	public INetworkMonitorManager getManager() {
		return manager;
	}

	public void setManager(INetworkMonitorManager manager) {
		this.manager = manager;
	}

	public ExecutorsFactory getExecutors() {
		return executors;
	}

	public void setExecutors(ExecutorsFactory executors) {
		this.executors = executors;
	}

	private Map<String,Map<String, String>> parameters = new HashMap<String, Map<String,String>>();
	
	
	public MeasurementTask createMeasuremetTask (String type, ResourceValue src, ResourceValue dst, int session) throws InvalidTaskTypeException{
		MessageParser parser = parsers.getParser(type);	
		if (parser == null)
			throw new InvalidTaskTypeException("Unknown parser");
		Executor executor = executors.getExecutor(type);
		if (executor == null)
			throw new InvalidTaskTypeException("Unknown executor");
		
		Map<String, String> params = new HashMap<String, String>();
		Map<String, String> p = parameters.get(type);
		if (p!= null)
			params.putAll(p);
		MeasurementTask task = new MeasurementTask(src,dst, parser,executor,params, session);
		return task;
	}
	
}
