package pl.psnc.expres.remote.network.task;

import java.util.HashMap;
import java.util.Map;

import pl.psnc.expres.model.resource.ResourceValue;
import pl.psnc.expres.remote.network.executors.Executor;
import pl.psnc.expres.remote.network.executors.ExecutorException;
import pl.psnc.expres.remote.network.parsers.MessageParser;

/**
 * Class represents measurement task. It allows creating measurement request and 
 * parsing the result
 * 
 * @author Lucas Dolata <ldolata@man.poznan.pl>
 *
 */
public class MeasurementTask{
	/**Measurement source point*/
	private ResourceValue source;
	
	/**Measurement destination point*/
	private ResourceValue destination;
	
	/**Parameters for measurement task*/
	private Map<String, String> paramaters;
	
	/**Parser for creating request and decoding results*/
	private MessageParser parser;
	
	/**Execute command*/
	private Executor executor;
	
	/** Related session identifier*/
	private int session;
	
	/**Measurement results*/
	private Map<String, Object> result = new HashMap<String, Object>();
 	
	/***
	 * Creates MeasurementTask  
	 * 
	 * @param parser parser for creating request and decoding results
	 * @param defaultParameters default parameters for MeasurementTask
	 * @param session  identifier of session related with this task
	 */
	public MeasurementTask (ResourceValue source, ResourceValue destination, MessageParser parser, Executor executor,  Map<String, String> parameters, int session)
	{	 
		   this.source = source;
		   this.executor = executor;
		   this.destination= destination;
		   this.parser = parser;
           this.paramaters= parameters;
           this.session = session;
	}

	public void execute() throws ExecutorException{  
		result.clear();
		if (executor == null)
			throw new ExecutorException("Executor not defined");	
		executor.execute(source, destination, paramaters, parser, result);
	}
	public Map<String, String> getParamaters() {
		return paramaters;
	}
	public void setParamaters(Map<String, String> paramaters) {
		this.paramaters = paramaters;
	}
	public int getSession() {
		return session;
	}
	public void setSession(int session) {
		this.session = session;
	}
	public Map<String, Object> getResult() {
		return result;
	}
	public ResourceValue getSource() {
		return source;
	}

	public void setSource(ResourceValue source) {
		this.source = source;
	}

	public ResourceValue getDestination() {
		return destination;
	}

	public void setDestination(ResourceValue destination) {
		this.destination = destination;
	}

	public MessageParser getParser() {
		return parser;
	}

	public void setParser(MessageParser parser) {
		this.parser = parser;
	}

	public void setResult(Map<String, Object> result) {
		this.result = result;
	}
}
