package pl.psnc.expres.remote.network.sessions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import pl.psnc.expres.remote.network.task.MeasurementTask;
import pl.psnc.expres.remote.network.value.NetworkMetric;

/**
 * Abstract class as base for various kind of measurement sessions
 * 
 * @author Lucas Dolata <ldolata@man.poznan.pl>
 *
 */
public abstract class Session {
	
	/**Generates unique session identifier*/
	public static volatile int sequencer=0;
	
	/**Session identifier*/
	private int identifier;
	
	/**Session observer */
	private static SessionObserver observer;
	
	/**Session identifier*/
	private int identyfier = createIdentifer();
	
	/** Identifies if session is complete*/
	private boolean isComplete = false;
	
	
	public int getIdentyfier() {
		return identyfier;
	}

	/**Identifies requested bandwidth*/
	private long bandwidth;
	
	/**Start points identifiers*/
	private  List<Integer> startPoints;
	
	/**End points identifiers*/
	private  List<Integer> endPoints;

	/**Map for quick search of metrics*/
	private Map<String,NetworkMetric> resultCache = Collections.synchronizedMap(new HashMap<String,NetworkMetric>());
	
	/**Sorted list of results*/
	private List<NetworkMetric> result = Collections.synchronizedList(new ArrayList<NetworkMetric>());
	
	/**
	 * Return session identifier
	 * @return
	 */
	public int getIdentifier(){
		return identifier;
	}
	
	public long getBandwidth() {
		return bandwidth;
	}
	public void setBandwidth(long bandwidth) {
		this.bandwidth = bandwidth;
	}
	public List<NetworkMetric> getResult() {
		return result;
	}
	
	/**
	 * Returns session identifier
	 * @return
	 */
	public static int createIdentifer(){
		return sequencer++;
	}
	/**
	 * Starts session
	 * @throws SessionExeception
	 */
	public abstract void start() throws SessionExeception;
	/**
	 * Gets progress percentage of the session
	 * @return 
	 */
	public abstract int  getProgress ();
	/**
	 * Update session with completed task
	 * @param task task to update state
	 * @param complete true if task completed false as failed
	 */
	public abstract void update (MeasurementTask task, boolean complete) throws SessionExeception;
	/**
	 * Dispose all session elements
	 */
	public abstract void dispose ();
	/**
	 * Gets define session start  points
	 * @return start point identifier
	 */
	public List<Integer> getStartPoints(){
		return startPoints;
	}
	/**
	 * Gets define session end  points
	 * @return end point identifiers
	 */
	public List<Integer> getEndPoints (){
		return endPoints;
	}
	
	/**
	 * Gets session observer
	 * @return
	 */
	public SessionObserver getObserver(){
		return observer;
	}
	
	public void addNetworkMetric (NetworkMetric metric){
		if (metric ==null)
			return;
		String key = ""+metric.getTranslationNodeId()+":"+metric.getFileServerId();
		NetworkMetric old = resultCache.get(key);
		if (old== null){
			result.add(metric);
			resultCache.put(key, metric);
		}
	} 
	
	
	public NetworkMetric getNetworkMetric (int startPoint, int endPoint){
		String key = ""+startPoint+":"+endPoint;
		return resultCache.get(key);
	}
	
	public void removeNetworkMetrics (NetworkMetric metric){
		result.remove(metric);
		resultCache.remove(""+metric.getTranslationNodeId()+":"+metric.getFileServerId());
	}

	public List<NetworkMetric> getNetworkMetrics (){
		return result;
	}
	
	public void setComplete(boolean isComplete) {
		this.isComplete = isComplete;
	}

	public void setObserver(SessionObserver observer) {
		Session.observer = observer;
	}

	public boolean isComplete() {
		return isComplete;
	}

	public void setStartPoints(List<Integer> startPoints) {
		this.startPoints = startPoints;
	}

	public void setEndPoints(List<Integer> endPoints) {
		this.endPoints = endPoints;
	}
	
}
