package pl.psnc.expres.remote.network.sessions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import pl.psnc.expres.remote.network.task.InvalidTaskTypeException;
import pl.psnc.expres.remote.network.task.MeasurementTask;
import pl.psnc.expres.remote.network.value.NetworkMetric;

public class DelayQueringSessionStage extends SessionStage {
	
	public final String DEAFAULT_DELAY_QUERING = "ping";
	
	/**Name for task which will measure delay between two nodes*/
	private String delayQueringTaskName;
	
	/**Number of measured tasks*/
	public volatile int numberOfMeasuredTask;
	
	/**Number of task in stage*/
	public volatile int numberOfTasks;
	
	/**List of submitted tasks*/
	public List<MeasurementTask> tasks = new ArrayList<MeasurementTask>();
	
	
	public DelayQueringSessionStage (){
		delayQueringTaskName = DEAFAULT_DELAY_QUERING;
	}
	
	public DelayQueringSessionStage (String delayQueringTaskName){
		this.delayQueringTaskName=delayQueringTaskName; 
	}
	
	@Override
	public double progress() {
		return numberOfMeasuredTask*100/numberOfTasks;
	}

	@Override
	public void start() throws SessionExeception{
		MeasurementTask task=null;
		Session session = super.getSession();
		if (session==null || session.getEndPoints()==null || session.getStartPoints()==null)
			throw new SessionExeception("End points or Start point list is null");
		int startLenght = session.getStartPoints().size();
		int endLenght = session.getEndPoints().size();
		
		numberOfTasks = startLenght*endLenght;
		
		for (int i=0;i<startLenght;i++){
			for (int j=0;j<endLenght;j++){
					try {
						if (session.getObserver()!= null)
							task =session.getObserver().requestSessionTask(delayQueringTaskName, session.getStartPoints().get(i), session.getEndPoints().get(j), session.getIdentifier());
							if (task != null)
								tasks.add(task);
						} catch (InvalidTaskTypeException e) {
							e.printStackTrace();
						}
				
			}
		}
		
	}

	@Override
	public void update(MeasurementTask task, boolean complete) {
		Session session = super.getSession();
		
		NetworkMetric metric = session.getNetworkMetric(task.getSource().getId(), task.getDestination().getId());
		
		if (!complete){
			if (metric!= null)
				session.removeNetworkMetrics(metric);
			System.out.println ("Task failed:"+task.getSource().getHostname()+":"+task.getDestination().getHostname());
		}else{
			
			Double delay = ((Double)task.getResult().get("delay"));
			Double loss  = ((Double)task.getResult().get("loss"));
			
			System.out.println ("Task completed:"+task.getSource().getHostname()+":"+task.getDestination().getHostname()+":"+delay+":"+loss);
			
			if (delay != null && loss !=null){
				if (metric == null){
					metric = new NetworkMetric(task.getSource().getId(), task.getDestination().getId());
					session.addNetworkMetric(metric);
				}
				metric.setDelay(delay.doubleValue());
				metric.setLoss(loss.doubleValue());
			}
		}
		numberOfMeasuredTask++;
		if (numberOfMeasuredTask == numberOfTasks){
			Collections.sort(session.getResult(), new DelayComparator());
			System.out.println ("Delay quering task complete:"+progress());
			for (NetworkMetric m:session.getNetworkMetrics()){
				System.out.println (m.getTranslationNodeId()+":"+m.getFileServerId()+":"+m.getDelay());
			}
			setComplete(true);
		}
	}

}
